import {ApplicationRef, Component, EventEmitter, Input, OnChanges, OnDestroy, Output} from '@angular/core';
import { NzMessageService, UploadXHRArgs, UploadFile } from 'ng-zorro-antd';


@Component({
  selector: 'app-upload-dragon-bone',
  templateUrl: './upload-dragon-bone.component.html',
  styleUrls: ['./upload-dragon-bone.component.scss']
})
export class UploadDragonBoneComponent implements OnDestroy, OnChanges {
  uploading = false;
  progress = 0;
  @Input()
  btnName = '配置龙骨动画';
  @Input()
  animaNames = [];

  @Input()
  skeJsonData = {};
  @Input()
  texJsonData = {};
  @Input()
  texPngData = {};
  
  @Output()
  save = new EventEmitter();

  @Output()
  refreshEmitter = new EventEmitter();

  // @Input()
  // picUrl;
  // @Input()
  // canDelete = false;
  // @Output()
  // imageUploaded = new EventEmitter();
  // @Output()
  // imageUploadFailure = new EventEmitter();
  // @Output()
  // delete = new EventEmitter();
  // @Input()
  // picItem = null;
  // @Input()
  // iconSize = 2;
  // @Input()
  // TIP = 'Click here to upload image';
  // @Input()
  // disableUpload = false;


  uploadUrl;
  uploadData;

  animaPanelVisible = false;

  isSkeJsonLoading = false;
  isTexJsonLoading = false;
  isTexPngLoading = false;

  constructor(private appRef: ApplicationRef, private nzMessageService: NzMessageService) {

    this.uploadUrl = (<any> window).courseware.uploadUrl();
    this.uploadData = (<any> window).courseware.uploadData();

    window['air'].getUploadCallback = (url, data) => {
      this.uploadUrl = url;
      this.uploadData = data;
    };

  }
  ngOnChanges() {
 
  }

  setAnimaBtnClick() {
    this.animaPanelVisible = true;
    this.refresh();
  }

  animaPanelCancel() {
    this.animaPanelVisible = false;
    this.refresh();
  }

  animaPanelOk() {
    this.sendItemDragonBoneData();
    this.animaPanelVisible = false;
    this.refresh();
  }

  sendItemDragonBoneData() {
    const data = {};
    data['skeJsonData'] = this.skeJsonData;
    data['texJsonData'] = this.texJsonData;
    data['texPngData'] = this.texPngData;
    this.save.emit(data);
  }


  skeJsonHandleChange(e) {
    console.log('e: ', e);
    switch (e.type) {
      case 'start':
        this.isSkeJsonLoading = true;
        break;

      case 'success':
        this.skeJsonData['url'] = e.file.response.url;
        this.skeJsonData['name'] = e.file.name;
        this.nzMessageService.success('上传成功');
        this.isSkeJsonLoading = false;
        break;

      case 'progress':
        break;
    }
  }

  texJsonHandleChange(e) {
    console.log('e: ', e);
    switch (e.type) {
      case 'start':
        this.isTexJsonLoading = true;
        break;

      case 'success':
        this.texJsonData['url'] = e.file.response.url;
        this.texJsonData['name'] = e.file.name;
        this.nzMessageService.success('上传成功');
        this.isTexJsonLoading = false;
        break;

      case 'progress':
        break;
    }
  }

  texPngHandleChange(e) {
    console.log('e: ', e);
    switch (e.type) {
      case 'start':
        this.isTexPngLoading = true;
        break;

      case 'success':
        this.texPngData['url'] = e.file.response.url;
        this.texPngData['name'] = e.file.name;
        this.nzMessageService.success('上传成功');
        this.isTexPngLoading = false; 
        break;

      case 'progress':
        break;
    }
  }



  /**
   * 刷新 渲染页面
   */
  refresh() {

    // this.refreshEmitter.emit();
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }


  closePanel() {
    console.log(' in closePanel ');
    this.refresh();
  }



  ngOnDestroy() {
  }

  linkInputed (ske, tex, png) {
    this.skeJsonData["url"] = ske.url;
    this.skeJsonData["name"] = ske.name;
    this.texJsonData["url"] = tex.url;
    this.texJsonData["name"] = tex.name;
    this.texPngData["url"] = png.url;
    this.texPngData["name"] = png.name;

    this.animaPanelOk();
  }

  handle_dragover(e) {
    e.preventDefault();
  }

  handle_drop(e) {
    e.preventDefault();
    const dt = e.dataTransfer.getData("text/plain");
    console.log("handle_drop===", dt);
    if (!dt) {
      return;
    }
    try {
      const {ske, tex, png} = JSON.parse(dt);
      if (!ske || !tex || !png || 
        ske.url.indexOf("teach")<0 || ske.url.indexOf("cdn")<0 || ske.url.indexOf(".json")<0 ||
        tex.url.indexOf("teach")<0 || tex.url.indexOf("cdn")<0 || tex.url.indexOf(".json")<0 ||
        png.url.indexOf("teach")<0 || png.url.indexOf("cdn")<0 || png.url.indexOf(".png")<0 ||
        !ske.name || !tex.name || !png.name
        ) {
        console.warn("handle_drop拖拽在线骨骼动画传递参数不合法，应该是{ske:{url:'', name:''},tex:{url:'', name:''},png:{url:'', name:''}}");
        return;
      }
      this.linkInputed(ske, tex, png);
    } catch (error) {
      console.warn("handle_drop拖拽在线骨骼动画传递参数不合法，应该是{ske:{url:'', name:''},tex:{url:'', name:''},png:{url:'', name:''}}");
    }
  }

}
