import { Component, OnDestroy, OnChanges, OnInit, ApplicationRef, ChangeDetectorRef, ViewChild, ElementRef } from '@angular/core';
import { ComponentBase } from './ComponentBase';
import { MetaFormCreator } from './mataFormCreator';

@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent extends ComponentBase implements OnInit, OnChanges, OnDestroy {
  // 储存数据用
  saveKey = "jj_15";

  item = {
    title: "",
    audio_url: '',
    questions: [],
  };
  isVisible = false;
  deleteTitle = "是否删除题目";
  deleteCallback = function () { };
  openDelete(title, callback) {
    this.deleteCallback = callback;
    this.deleteTitle = title;
    this.isVisible = true;
  }
  handleCancel() {
    this.isVisible = false;
  }
  handleOk() {
    this.deleteCallback && this.deleteCallback();
    this.handleCancel();
  }


  init(): void {
    // console.log(new MetaFormCreator().create());
    if (this.item.questions.length == 0) {
      this.addquestion();
    }
  }

  removeoption(i, j) {
    this.openDelete("确定减少选项？", () => {
      this.item.questions[i].options.splice(j, 1);
      this.save();
    })
  }
  copyoption(i, j) {
    let data = this.item.questions[i].options[j];
    this.item.questions[i].options.push(JSON.parse(JSON.stringify(data)));
    this.save();
  }

  addoption(i) {
    this.item.questions[i].options.push({
      type: 'img',
      image: '',
      text: '',
      audio: '',
      audioName: '',
    })
    this.save();
  }

  removequestion(i) {
    this.openDelete("确定删除题目？", () => {
      this.item.questions.splice(i, 1);
      this.save();
    })
  }

  addquestion() {
    this.item.questions.push({
      title: "",
      options: [],
    });
    this.addoption(this.item.questions.length - 1);
    this.save();
  }

  onItemAudioUploadSuccess(e, item) {
    item.audio_url = e.url;
    this.save();
  }

  deleteBgAudio() {
    this.save();
  }
  ngChange() {
    this.save();
  }
}