

var ctx, sprite, img, _w, _h, play;
function initPreviewPage(imgIndex, callback){  
  img = new Image(); 
  img.onload = function(){
    // play=$("#play");
    // play.attr("width",img.width);
    // play.attr("height",img.height);
    play = document.createElement('canvas');
    $(play).attr("width",img.width);
    $(play).attr("height",img.height);
    ctx=play.getContext("2d");  
    ctx.clearRect(0, 0, img.width, img.height); 
    ctx.drawImage(img,0,0);  

    renderText(imgIndex);

    callback&&callback(); 
  }
  img.src = "../lib/images/jiangzhuang_Img"+imgIndex+"@3x.png"; 
}

function renderText(imgIndex){
  var praise = $("#praise").val();
  var date = $("#date").val();
  var sign = $("#sign").val();
  ctx.font="18px Arial";
  ctx.textAlign='center';
  if(imgIndex==1){
    ctx.fillText(praise,230,170); 
    ctx.fillText(date,325,240);
    ctx.fillText(sign,150,240);
  } else if (imgIndex==2){
    ctx.font="30px Arial";
    ctx.fillText("You are very good!",410,330); 
    ctx.fillText("2019-12-24",275,495);
    ctx.fillText("Tom",605,495);
  } else if (imgIndex==3){
    ctx.fillText(praise,230,155); 
    ctx.fillText(date,255,205);
    ctx.fillText(sign,255,255);
  } else if (imgIndex==4){
    ctx.fillText(praise,250,120); 
    ctx.fillText(date,210,240);
    ctx.fillText(sign,335,240);
  } else if (imgIndex==5){
    ctx.fillText(praise,250,165); 
    ctx.fillText(date,250,250); 
  } else if (imgIndex==6){
    ctx.fillText(praise,270,185); 
    ctx.fillText(date,305,267);
    ctx.fillText(sign,305,225);
  }
  
}

$(function(){ 

  _w = $(window).width();
  _h = $(window).height(); 

  $(".img-area").bind('click',function(){ 
    $(".check-item").attr("checked",false).hide();
    $(this).find(".check-item").attr("checked",true).show();
    $(".alert").html("").hide();
  });

  $(".close-view").bind('click',function(){
    $(this).hide();
    $("#playView").hide();
    $(".edit-form").show(); 
  });

  $(".preview").bind('click', function(){
    let cardIndex = $('input:checkbox[class="check-item"]:checked').eq(0).val();  
    if(cardIndex==undefined){
      $(".alert").html("请选择奖状！").show(300);
      return;
    }
    $(".edit-form").hide(); 
    initPreviewPage(cardIndex,function(){ 
      let imgUrl = play.toDataURL('image/jpeg', 1.0);
      $('#playView').attr('src', imgUrl);
      $('#playView').css({height: _w});
      $('#playView')[0].onload = function(){
        var play_w = $('#playView').width();
        var right = Math.floor(play_w/2)+35;  
        var top = _w-Math.floor(play_w/2)-35;
        var margin_top = Math.floor((_h-play_w)/2);
        $('#playView').css({
          "position": "absolute",
          "transform":"rotate(90deg)",
          "right": (right-_w)+"px",
          "top": (top+margin_top)+"px"
        }).show();
      };  
    }); 
    $(".close-view").show();  
  });

});