import { middleLayerBase } from "./middleLayerBase";
import { initAir } from './air';

const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends middleLayerBase {

  role;
  token;
  // 统一释放异步资源的方法
  async onLoad() {
    initAir(this);
    this.reWriteAir();
    this.role = 'student';

    this.onMiddleLayerLoadingFinish();
  }

  async start() {
    this.node.zIndex = 9999;
    cc.game.addPersistRootNode(this.node);
    global.middleLayer = cc.find('middleLayer').getComponent('middleLayer');

    this.loadOnlineCourseWare(23751);
  }

  onHomeworkFinish(callBack, data = null) {
    if (!this.token) {
      return;
    }
    if (typeof (callBack) == 'object') {
      data = callBack;
    }
    this.callNetworkApiPost(`/api/dige/v1/user/report`, {
      token: this.token,
      syllabus_id: this.courseItem.course_id,
      courseware_id: this.courseItem.id,
      template_name: this.courseItem.template_name,
      study_duration: Date.now() - this.courseOpenTimeStamp,
      result: JSON.stringify(data),
    }, res => {
      callBack && callBack(res);
    });
  }

  initListener() {
    
  }

  reWriteAir() {
    (<any>window).courseware.getData = (callback) => {
      let data = null;
      if (this.courseItem && this.courseItem.data) {
        data = JSON.parse(this.courseItem.data);
      }
      this.log("===成功调用getData===" + JSON.stringify(data));
      callback && callback(data);
    }
    (<any>window).courseware.stopTest = (callback) => {
      (<any>window).courseware.hasCalledStartTest = false;
      console.log(`===成功调用stopTest===`);
      if (!callback) {
        // 不传回调函数就表示取消评测
        console.log(`===成功取消录音评测===`);
        (<any>window).courseware.callOcMethod("stopTest", { isBreak: 1 });
        return;
      }
      // 结束录音
      (<any>window).air.testCallBack = (res) => {
        res = typeof (res) == 'string' ? res : JSON.stringify(res);
        console.log(`===成功调用testCallBack=== res == ${res}`);
        this.saveRecordResult(res);
        callback && callback(res);
        (<any>window).air.testCallBack = null;
      };
      (<any>window).courseware.callOcMethod("stopTest", {});
    }


    if (!(<any>window).air) {
      (<any>window).air = {};
    }
    (<any>window).air.hideAirClassLoading = () => {
      (<any>window).air.onCourseInScreen && (<any>window).air.onCourseInScreen(() => {
        console.log("***成功调用onCourseInScreen***");
        (<any>window).air.onCourseInScreen = null;
      });
      this.hideWaitingLetters();
    }
  }

  saveRecordResult(recordResult) {
    if (!this.token) {
      return;
    }
    const result = JSON.parse(recordResult);
    this.callNetworkApiPost(`/api/dige/v1/record/save`, {
      token: this.token,
      syllabus_id: this.courseItem.course_id,
      courseware_id: this.courseItem.id,
      record_url: result.audioUrl,
      test_result: recordResult
    }, () => { });
  }

  onMiddleLayerLoadingFinish() {
		if (cc.sys.isNative && cc.sys.os == cc.sys.OS_IOS) {
			jsb.reflection.callStaticMethod(
				"RootViewController",
				"getMiddleLayerInfoFinish:",
				""
			);
		}
		if (cc.sys.isNative && cc.sys.os == cc.sys.OS_ANDROID) {
			jsb.reflection.callStaticMethod(
				"com/iplayabc/cocos/AppActivity",
				"getMiddleLayerInfoFinish",
				"(Ljava/lang/String;)Ljava/lang/String;",
				""
			);
		}
	}
}
