import express from "express";
import os from "os";
import readline from "readline";
import { build } from "./buildCocos.js";

const networkInfo = os.networkInterfaces();

let host = '';
for (const infos of Object.values(networkInfo)) {
  for (const info of infos) {
    if (info.family == 'IPv4') {
      if (info.address.split('.')[0] != "127") {
        host = info.address;
      }
    }
  }
}

var app = express();

app.use('/publish', express.static('publish'));

app.get('/', function (req, res) {
  res.send('Hello World');
})

let port = '';
var server = app.listen(8081, function () {

  port = server.address().port

  console.log("测试服务已启动：%s:%s", host, port)

})

const rl = readline.createInterface({
  input: process.stdin,
  output: process.stdout
})
rl.on('line', async (str) => {
  if (str.trim() == 'build') {
    await build();
    console.log("测试服务已启动：%s:%s", host, port)
    console.log('输入 build 构建。')
  } else {
    console.log("测试服务已启动：%s:%s", host, port)
    console.log('输入 build 构建。')
  }
})
