cc.Class({
	extends: cc.Component,
	properties: {},

	getData(callBack) {
		const uri = 'courseware/v1/getdata';
		const syllabus_id = this.bundleInfoList[this.currentBundleIndex].syllabus_id;
		const data = {
			courseid: syllabus_id
		};
		this.callNetworkApiGet(uri, data, callBack);
	},

	onHomeworkFinish(callBack) {
		if (this.role == 'teacher') {
			return;
		}
		const uri = 'app_source/v1/student/homework/finished';
		const data = {
			syllabus_id: this.syllabus_id,
			homework_id: this.homework_id,
			token: this.token,
			score: 100
		};
		console.log('data = ' + JSON.stringify(data));
		this.callNetworkApiPost(uri, data, callBack);
	},

	callNetworkApiGet(uri, data, callBack) {
		let queryStr = '?';
		for (const key in data) {
			if (Object.hasOwnProperty.call(data, key)) {
				const value = data[key];
				queryStr += `${key}=${value}`;
			}
		}
		const xhr = new XMLHttpRequest();
		xhr.onreadystatechange = () => {
			if (xhr.readyState == 4 && (xhr.status >= 200 && xhr.status < 400)) {
				const responseData = JSON.parse(xhr.responseText);
				callBack(JSON.parse(responseData.data));
			}
		};
		const url = `${this.baseUrl}${uri}${queryStr}`;
		console.log('url = ' + url);
		xhr.open('GET', url, true);
		xhr.send();
	},

	callNetworkApiPost(uri, data, callBack) {
		const xhr = new XMLHttpRequest();
		const url = `${this.baseUrl}${uri}`;
		xhr.open("POST", url, true);
		xhr.setRequestHeader('content-type', 'application/json');
		xhr.onreadystatechange = () => {
			if (xhr.readyState == 4) {
				callBack(JSON.parse(xhr.responseText));
			}
		}
		xhr.send(JSON.stringify(data));
	},

	start() {

		this.node.zIndex = 9999;
		this.showWaitingLetters();

		cc.game.addPersistRootNode(this.node);


		this.initListener();


		this.getBundleInfoList();
	},

	asyncDelayLog(str) {
		console.log(str);
		return new Promise((resolve, reject) => {
			setTimeout(() => {
				resolve();
			}, 1);
		});
	},

	getBundleInfoList() {


		const jsonStr = this.callNativeFunction({ name: 'loadSceneList', value: '' });
		// const jsonStr = `{"bundleInfoList":[{"sceneName":"dfzx_cocos_T_FT_01","version":"c1a41","bondleUrl":"http://staging-teach.cdn.ireadabc.com//h5template/dfzx_cocos_T_FT_01/v3/android/dfzx_cocos_T_FT_01","token":"eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6NDYyLCJ1dWlkIjoiZDNlODE0OGItOTNlNC00NzdiLWEyMmEtMjNkYTk4ZWVlMGYwIiwicGhvbmUiOiIxNTk0MDgzMzk1MCIsIm5pY2tfbmFtZSI6IuaZk-aFp-a1i-ivlSIsIm9yZ19pZCI6MTEsInNjaG9vbF9pZCI6MjA0LCJjbGFzc19pZCI6MTQxLCJkZnp4X3VzZXJfdXVpZCI6ImVmMTNhNTI3ZDg2ZDQ1MGY4MWJjMWE1OWQ0NDcyZTQwIiwiZGVsIjowLCJjcmVhdGVkX2RhdGUiOiIyMDIwLTA4LTA2VDA2OjA1OjUxLjAwMFoiLCJ1cGRhdGVkX2RhdGUiOiIyMDIwLTA4LTA3VDA4OjI3OjQwLjAwMFoiLCJhY2NvdW50X3R5cGUiOjIsImVuZF9kYXRlIjoiMjAyMS0xMC0xM1QxNjowMDowMC4wMDBaIiwiY2xhc3NSb2xlIjoic3R1IiwiaWF0IjoxNjI5ODYyMTA2LCJleHAiOjE2MzI0NTQxMDZ9.pKvGgI9yijd57vJBLAM9wuiPV5KkCriezV-FlD8fmLI","baseUrl":"http://staging-teach.ireadabc.com/api/","homework_id":"313","syllabus_id":"18984","role":"student"},{"sceneName":"dfzx_cocos_T_FT_01","version":"c1a41","bondleUrl":"http://staging-teach.cdn.ireadabc.com//h5template/dfzx_cocos_T_FT_01/v3/android/dfzx_cocos_T_FT_01","token":"eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6NDYyLCJ1dWlkIjoiZDNlODE0OGItOTNlNC00NzdiLWEyMmEtMjNkYTk4ZWVlMGYwIiwicGhvbmUiOiIxNTk0MDgzMzk1MCIsIm5pY2tfbmFtZSI6IuaZk-aFp-a1i-ivlSIsIm9yZ19pZCI6MTEsInNjaG9vbF9pZCI6MjA0LCJjbGFzc19pZCI6MTQxLCJkZnp4X3VzZXJfdXVpZCI6ImVmMTNhNTI3ZDg2ZDQ1MGY4MWJjMWE1OWQ0NDcyZTQwIiwiZGVsIjowLCJjcmVhdGVkX2RhdGUiOiIyMDIwLTA4LTA2VDA2OjA1OjUxLjAwMFoiLCJ1cGRhdGVkX2RhdGUiOiIyMDIwLTA4LTA3VDA4OjI3OjQwLjAwMFoiLCJhY2NvdW50X3R5cGUiOjIsImVuZF9kYXRlIjoiMjAyMS0xMC0xM1QxNjowMDowMC4wMDBaIiwiY2xhc3NSb2xlIjoic3R1IiwiaWF0IjoxNjI5ODYyMTA2LCJleHAiOjE2MzI0NTQxMDZ9.pKvGgI9yijd57vJBLAM9wuiPV5KkCriezV-FlD8fmLI","baseUrl":"http://staging-teach.ireadabc.com/api/","homework_id":"313","syllabus_id":"18984","role":"student"}],"defaultBundleIdx":0}`;


		const { bundleInfoList, defaultBundleIdx } = JSON.parse(jsonStr);


		this.bundleInfoList = bundleInfoList;



		this.jumpToBundleByIndex(defaultBundleIdx);

	},

	jumpToBundleByIndex(index) {
		this.currentBundleIndex = index;
		const currentBundleInfo = this.bundleInfoList[this.currentBundleIndex];

		const btnLeft = this.node.getChildByName('BtnLeft');
		const btnRight = this.node.getChildByName('BtnRight');
		btnLeft.active = true;
		btnRight.active = true;

		if (this.currentBundleIndex == 0) {

			btnLeft.active = false;
		}
		if (this.currentBundleIndex == this.bundleInfoList.length - 1) {

			btnRight.active = false;
		}

		this.baseUrl = currentBundleInfo.baseUrl;
		this.token = currentBundleInfo.token;
		this.homework_id = currentBundleInfo.homework_id;
		this.syllabus_id = currentBundleInfo.syllabus_id;
		this.role = currentBundleInfo.role;

		cc.assetManager.loadBundle(currentBundleInfo.bondleUrl, { version: currentBundleInfo.version }, async (err, bundle) => {

			if (err) {
				return this.asyncDelayLog(err);
			}

			bundle.loadScene(currentBundleInfo.sceneName, (err, scene) => {
				if (err) {
					this.asyncDelayLog('err: ', err);
				}

				this.hideWaitingLetters();

				cc.director.runScene(scene);

			});

		});

	},

	loadDefaultBundle() {


		const jsonStr = this.callNativeFunction({ name: 'loadScene', value: '' });

		const {
			sceneName,
			version,
			bondleUrl,
			token,
			baseUrl,
			homework_id,
			syllabus_id,
			role
		} = JSON.parse(jsonStr);


		this.baseUrl = baseUrl;
		this.token = token;
		this.homework_id = homework_id;
		this.syllabus_id = syllabus_id;
		this.role = role;


		cc.assetManager.loadBundle(bondleUrl, { version: version }, (err, bundle) => {

			if (err) {
				return this.asyncDelayLog(err);
			}

			bundle.loadScene(sceneName, (err, scene) => {

				this.hideWaitingLetters();

				cc.director.runScene(scene);

			});
		});

	},

	initListener() {
		const exitBtn = this.node.getChildByName('ExitBtn');
		exitBtn.on('click', () => {
			cc.tween(exitBtn)
				.to(0.1, { scaleX: 0.9, scaleY: 1.1 })
				.to(0.1, { scaleX: 1.1, scaleY: 0.9 })
				.to(0.1, { scaleX: 1, scaleY: 1 })
				.call(() => {
					cc.game.removePersistRootNode(this.node);
					cc.director.loadScene("emptyScene", () => {
						this.callNativeFunction({ name: 'exit', value: '' });
					});
				})
				.start();
		});

		const btnLeft = this.node.getChildByName('BtnLeft');
		btnLeft.on('click', () => {
			if (this.currentBundleIndex - 1 < 0) {
				return;
			}
			this.jumpToBundleByIndex(this.currentBundleIndex - 1);
		});

		const btnRight = this.node.getChildByName('BtnRight');
		btnRight.on('click', () => {
			if (this.currentBundleIndex + 1 >= this.bundleInfoList.length) {
				return;
			}
			this.jumpToBundleByIndex(this.currentBundleIndex + 1);
		});

		const BtnStartLocal = cc.find('middleLayer/ui/BtnStartLocal');
		BtnStartLocal.on('click', () => {
			
		});
	},

	callNativeFunction(param) {
		const paramStr = JSON.stringify(param);
		if (cc.sys.isNative && cc.sys.os == cc.sys.OS_IOS) {
			return jsb.reflection.callStaticMethod('CocosMng', 'cocosWithNativeProtocol:', paramStr);
		} else if (cc.sys.isNative && cc.sys.os == cc.sys.OS_ANDROID) {
			return jsb.reflection.callStaticMethod('com/iplayabc/cocos/AppActivity', 'cocosWithNativeProtocol', '(Ljava/lang/String;)Ljava/lang/String;', paramStr);
		} else {
			throw ('非源生环境');
		}
	},

	showWaitingLetters() {
		const colorList = this.getRainbowColorList();
		const layout = cc.find('middleLayer/layout');
		// layout.active = true;
		const str = 'Now Loading...';
		str.split('').forEach((word, idx) => {
			const node = new cc.Node();
			const label = node.addComponent(cc.Label);
			label.string = word;
			node.parent = layout;
			node.color = colorList[idx];
			cc.tween(node)
				.delay(idx / 4)
				.by(0.3, { y: 50 }, { easing: 'sineOut' })
				.by(0.3, { y: -50 }, { easing: 'sineIn' })
				.delay((str.length - idx) / 4)
				.union()
				.repeatForever()
				.start();
		});
		const totalWidth = layout.children.reduce((width, node, idx) => {
			return width + node.width;
		}, 0);
		layout.width = totalWidth;
	},

	hideWaitingLetters() {
		const layout = cc.find('middleLayer/layout');
		layout.active = false;
	},

	showLog(str) {
		if (!this.logList) {
			this.logList = [];
		}
		this.logList.push(str);
		console.log(str);

		if (this.logList.length == 1) {
			this.showOneLog();
		}
	},

	showOneLog() {
		const str = this.logList[0];
		if (str === undefined) {
			return;
		}
		const node = new cc.Node();
		node.anchorX = 0.5;
		const label = node.addComponent(cc.RichText);
		label.string = `<outline color=black width=3>${str}</outline>`;
		label.maxWidth = this.node.width / 2;
		node.x = this.node.width / 4;
		node.y = -this.node.height / 2;
		node.parent = this.node;
		cc.tween(node)
			.to(5, { y: this.node.height })
			.removeSelf()
			.start();
		setTimeout(() => {
			this.logList.shift();
			this.showOneLog();
		}, 1000);
	},

	getRainbowColorList() {
		return [
			cc.color(255, 255, 0),
			cc.color(128, 255, 0),
			cc.color(0, 255, 0),
			cc.color(0, 0, 0),

			cc.color(0, 255, 128),
			cc.color(0, 255, 255),

			cc.color(0, 128, 255),
			cc.color(0, 0, 255),
			cc.color(128, 0, 255),
			cc.color(255, 0, 255),
			cc.color(255, 0, 128),

			cc.color(255, 0, 0),
			cc.color(255, 128, 0),
			cc.color(255, 255, 0),
		];
	}
});
