

export function initAir(_this) {
  const realAir = {
    uploadUrl: "",
    uploadData: null,
    engineInfo: null,
    hideAirClassLoading(templateName, loadData) {
      _this.log("***成功调用hideAirClassLoading***");
      window.air.onCourseInScreen && window.air.onCourseInScreen(() => {
        _this.log("***成功调用onCourseInScreen***");
      });
    },
    osmoCallback: function (res) {
      _this.log(`***成功调用osmoCallback***参数==${res}`);
    },
    osmoHandwritingCallback: function (res) {
      _this.log(`***成功调用osmoHandwritingCallback***参数==${res}`);
    },
    osmoHandwritingMlkitCallback: function (res) {
      _this.log(`***成功调用osmoHandwritingMlkitCallback***参数==${res}`);
    },
    osmoFingerReadCallback: function (res) {
      _this.log(`***成功调用osmoFingerReadCallback***参数==${res}`);
    },
    getEngineInfoCallback: null,
    recognitionCameraCallBack: null,
    testCallBack: null,
    recordCallBack: null,
    onCourseInScreen: null,
  };
  try {
    window.air = new Proxy(realAir, {
      set: function (target, key, value, receiver) {
        let newValue = value;
        if (key == "osmoCallback" || key == "osmoHandwritingCallback" || key == "osmoHandwritingMlkitCallback" || key == "osmoFingerReadCallback") {
          newValue = function (res) {
            _this.log(`||==成功调用${key}==||参数==${JSON.stringify(res)}`);
            if(typeof(res) == 'string') {
              value(res);
            } else {
              value(JSON.stringify(res));
            }
          }
        }
        return Reflect.set(target, key, newValue, receiver);
      },
      get: function (target, key, receiver) {
        return Reflect.get(target, key, receiver);
      },
      deleteProperty: function (target, key) {
        return Reflect.deleteProperty(target, key);
      }
    });
  } catch (e) {
    console.error("浏览器不支持ES6新特性Proxy/Reflect，请使用谷歌浏览器！");
  }
  window.courseware = {
    getData(callback) {
      _this.log("===成功调用getData===");
      callback && callback(null);
    },
    uploadUrl() {
      _this.log("===成功调用uploadUrl===");
      return window.air.uploadUrl;
    },
    uploadData() {
      _this.log("===成功调用uploadData===");
      return window.air.uploadData;
    },
    nextPage() {
      _this.log("===成功调用nextPage===");
    },
    beforePage() {
      _this.log("===成功调用beforePage===");
    },
    jumpPage(page) {
      _this.log(`===成功调用jumpPage=== page == ${page}`);
    },
    sendAnswer(answerObj) {
      _this.log(`===成功调用sendAnswer=== answerObj == ${JSON.stringify(answerObj)}`);
      answerObj.callback && answerObj.callback();
    },
    getAnswer(queryObj, callback) {
      _this.log(`===成功调用getAnswer=== queryObj == ${JSON.stringify(queryObj)}`);
      callback && callback(null);
    },
    getTemplates(callback) {
      _this.log(`===成功调用getTemplates===`);
      callback && callback(null);
    },
    getTemplateUrl(templateName, callback) {
      _this.log(`===成功调用getTemplateUrl=== templateName == ${templateName}`);
      callback && callback(null);
    },
    gameEnd() {
      _this.log(`===成功调用gameEnd===`);
    },
    startRecord(testText) {
      _this.log(`===成功调用startRecord=== testText == ${testText}`);
      window.courseware.hasCalledStartRecord = true;
      window.courseware.callOcMethod("startRecord", { "params": testText });
    },
    stopRecord(isSpeechToText, _callback) {
      window.courseware.hasCalledStartRecord = false;
      _this.log(`===成功调用stopRecord=== isSpeechToText == ${isSpeechToText}`);
      let callback = _callback;
      let _isSpeechToText;
      if (isSpeechToText && typeof isSpeechToText === "function") {
        callback = isSpeechToText;
        _isSpeechToText = 1;
      } else {
        _isSpeechToText = isSpeechToText;
      }
      if (!callback) {
        // 不传回调函数就表示取消评测
        window.courseware.callOcMethod("stopRecord", { isBreak: 1 });
        return;
      }
      // 结束录音
      window.air.recordCallBack = (res) => {
        callback && callback(JSON.stringify(res));
        window.air.recordCallBack = null;
      };
      window.courseware.callOcMethod("stopRecord", { isBreak: 0, isSpeechToText: _isSpeechToText });
    },
    startTest(testText, option) {
      window.courseware.hasCalledStartTest = true;
      _this.log(`===成功调用startTest=== testText == ${testText}`);
      window.courseware.callOcMethod("startTest", { ...option, "params": testText });
    },
    stopTest(callback) {
      window.courseware.hasCalledStartTest = false;
      _this.log(`===成功调用stopTest===`);
      if (!callback) {
        // 不传回调函数就表示取消评测
        _this.log(`===成功取消录音评测===`);
        window.courseware.callOcMethod("stopTest", { isBreak: 1 });
        return;
      }
      // 结束录音
      window.air.testCallBack = (res) => {
        res = typeof(res) == 'string' ? res : JSON.stringify(res);
        _this.log(`===成功调用testCallBack=== res == ${res}`);
        callback && callback(res);
        window.air.testCallBack = null;
      };
      window.courseware.callOcMethod("stopTest", {});
    },
    openRecognitionCamera(callback) {
      window.courseware.hasCalledOpenRecognitionCamera = true;
      _this.log(`===成功调用openRecognitionCamera===`);
      window.air.recognitionCameraCallBack = (res) => {
        callback && callback(JSON.stringify(res));
        window.air.recognitionCameraCallBack = null;
      };
      window.courseware.callOcMethod("openRecognitionCamera", {});
    },
    closeRecognitionCamera() {
      window.courseware.hasCalledOpenRecognitionCamera = false;
      _this.log(`===成功调用closeRecognitionCamera===`);
      window.courseware.callOcMethod("closeRecognitionCamera", {});
    },
    getEngineInfo(callback) {
      _this.log(`===成功调用getEngineInfo===`);
      // 调用原生获取机器信息
      window.air.getEngineInfoCallback = (res) => {
        window.air.engineInfo = res;
        callback && callback(JSON.stringify(res));
        window.air.getEngineInfoCallback = null;
      };
      window.courseware.callOcMethod("getEngineInfo", {});
    },
    openOsmo() {
      window.courseware.hasCalledOpenOsmo = true;
      _this.log(`===成功调用openOsmo===`);
      window.courseware.callOcMethod("openOsmo", {});
    },
    closeOsmo() {
      window.courseware.hasCalledOpenOsmo = false;
      _this.log(`===成功调用closeOsmo===`);
      window.courseware.callOcMethod("closeOsmo", {});
    },
    openOsmoHandwriting(params = {}) {
      window.courseware.hasCalledOpenOsmoHandwriting = true;
      _this.log(`===成功调用openOsmoHandwriting===${JSON.stringify(params)}`);
      window.courseware.callOcMethod("openOsmoHandwriting", params);
    },
    closeOsmoHandwriting() {
      window.courseware.hasCalledOpenOsmoHandwriting = false;
      _this.log(`===成功调用closeOsmoHandwriting===`);
      window.courseware.callOcMethod("closeOsmoHandwriting", {});
    },
    openOsmoHandwritingMlkit(params = {}) {
      window.courseware.hasCalledOpenOsmoHandwritingMlkit = true;
      _this.log(`===成功调用openOsmoHandwritingMlkit===${JSON.stringify(params)}`);
      window.courseware.callOcMethod("openOsmoHandwritingMlkit", params);
    },
    closeOsmoHandwritingMlkit() {
      window.courseware.hasCalledOpenOsmoHandwritingMlkit = false;
      _this.log(`===成功调用closeOsmoHandwritingMlkit===`);
      window.courseware.callOcMethod("closeOsmoHandwritingMlkit", {});
    },
    openOsmoFingerRead(params = {}) {
      window.courseware.hasCalledOpenOsmoFingerRead = true;
      _this.log(`===成功调用openOsmoFingerRead===${JSON.stringify(params)}`);
      window.courseware.callOcMethod("openOsmoFingerRead", params);
    },
    closeOsmoFingerRead() {
      window.courseware.hasCalledOpenOsmoFingerRead = false;
      _this.log(`===成功调用closeOsmoFingerRead===`);
      window.courseware.callOcMethod("closeOsmoFingerRead", {});
    },
    callOcMethod(method, param) {
      const paramStr = JSON.stringify(param);
      _this.log(`===成功调用原生方法${method}===参数==${paramStr}`);
      if (cc.sys.isNative && cc.sys.os == cc.sys.OS_IOS) {
        return jsb.reflection.callStaticMethod('RootViewController', `${method}:`, paramStr);
      } else if (cc.sys.isNative && cc.sys.os == cc.sys.OS_ANDROID) {
        return jsb.reflection.callStaticMethod('com/iplayabc/cocos/AppActivity', method, '(Ljava/lang/String;)Ljava/lang/String;', paramStr);
      } else if (cc.sys.isNative && cc.sys.os == cc.sys.OS_WINDOWS) {
        console.log('汪汪汪')
      } else {
        console.error('非源生环境');
        if(method == 'getEngineInfo'){
          window.air.getEngineInfoCallback({isDev: 1});
        }
      }
    },
    freeAllOcMethod() {
      if (window.courseware.hasCalledStartRecord) {
        window.courseware.stopRecord();
      }
      if (window.courseware.hasCalledStartTest) {
        window.courseware.stopTest();
      }
      if (window.courseware.hasCalledOpenRecognitionCamera) {
        window.courseware.closeRecognitionCamera();
      }
      if (window.courseware.hasCalledOpenOsmo) {
        window.courseware.closeOsmo();
      }
      if (window.courseware.hasCalledOpenOsmoHandwriting) {
        window.courseware.closeOsmoHandwriting();
      }
      if (window.courseware.hasCalledOpenOsmoHandwritingMlkit) {
        window.courseware.closeOsmoHandwritingMlkit();
      }
      if (window.courseware.hasCalledOpenOsmoFingerRead) {
        window.courseware.closeOsmoFingerRead();
      }
    }
  };
}
