import fs from "fs";

function getFolderName(path) {
  let folderName = '';
  fs.readdirSync(path).find(fileName => {
    const st = fs.statSync(`${path}/${fileName}`);
    if (st.isDirectory()) {
      folderName = fileName;
    }
  });
  return folderName;
}
function editFolderMeta(path, folderName, isBundle) {
  const metaPath = `${path}/${folderName}.meta`;
  const metaDataStr = fs.readFileSync(metaPath);
  const metaData = JSON.parse(metaDataStr);
  metaData.isBundle = isBundle;
  metaData.isRemoteBundle = {
    ios: isBundle,
    android: isBundle
  };
  fs.writeFileSync(metaPath, JSON.stringify(metaData));
}


export function changeSettingToWebDesktop() {
  const path = '../play/assets'
  const folderName = getFolderName(path);
  editFolderMeta(path, folderName, false);
}

export function changeSettingsToBundle() {
  const path = '../play/assets'
  const folderName = getFolderName(path);
  editFolderMeta(path, folderName, true);
}