import { buildAndroidBundle } from "./buildAndroidBundle.js";
import { buildWebDesktop } from "./buildWebDesktop.js";
import { build_check } from "./build_check.js"
import { changeSettingsToBundle, changeSettingToWebDesktop } from "./changeSettings.js";
import { replaceUuids } from "./replaceUuids.js";
import { copyDir, removeDir } from "./utils.js";
import { replaceIndexHtml } from "./replaceIndexHtml.js";

// 构建前检查
build_check();

// 清理旧文件
await removeDir('./publish/play');
await removeDir('./publish/form');
await removeDir('./publish/ios');
await removeDir('./publish/android');
await removeDir('./publish/web_desktop');

// 构建form
copyDir('../form', 'publish/form');

// 替换uuid
replaceUuids();

// 构建play

// 改设置为非bundle
changeSettingToWebDesktop();

// 构建web_desktop
await buildWebDesktop();

await copyDir('../play/build/web-desktop', 'publish/play');

replaceIndexHtml();

console.log('构建 web desktop 成功！');

// 改设置为bundle
changeSettingsToBundle();

await buildAndroidBundle();

await copyDir('../play/build_android/jsb-link/remote', 'publish/android');

console.log('构建 android bundle 成功！');

// 改设置为非bundle
changeSettingToWebDesktop();