import { spawn } from "child_process";

const creatorBasePath = 'C:\\CocosDashboard_1.0.6\\resources\\.editors\\Creator';

export function buildWebDesktop() {
  return new Promise((resolve, reject) => {
    const buffer = spawn(
      `${creatorBasePath}\\2.4.0\\CocosCreator.exe`,
      ['--path', './', '--build', 'platform=web-desktop;debug=true', '--force'],
      { cwd: '../play' }
    );

    buffer.stdout.on('data', (data) => {
      console.log(`stdout: ${data}`);
    });

    buffer.stderr.on('data', (data) => {
      console.error(`stderr: ${data}`);
    });

    buffer.on('close', (code) => {
      console.log(`child process exited with code ${code}`);
      resolve();
    });
  });
}