

export function initAir(_this) {
  const realAir = {
    uploadUrl: "",
    uploadData: null,
    hideAirClassLoading(templateName,loadData) {
      _this.log("***成功调用hideAirClassLoading***");
      window.air.onCourseInScreen && window.air.onCourseInScreen(() => {
        _this.log("***成功调用onCourseInScreen***");
      });
    },
    osmoCallback: function(res){
      _this.log(`***成功调用osmoCallback***参数==${res}`);
    },
    osmoHandwritingCallback: function(res){
      _this.log(`***成功调用osmoHandwritingCallback***参数==${res}`);
    },
    osmoFingerReadCallback: function(res){
      _this.log(`***成功调用osmoFingerReadCallback***参数==${res}`);
    },
    getEngineInfoCallback: null,
    recognitionCameraCallBack: null,
    testCallBack: null,
    recordCallBack: null,
    onCourseInScreen: null,
  };
  try{
    window.air = new Proxy(realAir, {
      set: function (target, key, value, receiver) {
        let newValue = value;
        if (key=="osmoCallback"||key=="osmoHandwritingCallback"||key=="osmoFingerReadCallback") {
          newValue = function (res) {
            _this.log(`||==成功调用${key}==||参数==${JSON.stringify(res)}`);
            value(JSON.stringify(res));
          }
        }
        return Reflect.set(target, key, newValue, receiver); 
      },
      get: function (target, key, receiver) {
        return Reflect.get(target, key, receiver);
      },
      deleteProperty: function(target, key){
        return Reflect.deleteProperty(target, key);
      }
    });
  }catch(e){
    console.error("浏览器不支持ES6新特性Proxy/Reflect，请使用谷歌浏览器！");
  }
  window.courseware = {
    getData(callback) {
      _this.log("===成功调用getData===");
      callback && callback(null);
    },
    uploadUrl() {
      _this.log("===成功调用uploadUrl===");
      return window.air.uploadUrl;
    },
    uploadData() {
      _this.log("===成功调用uploadData===");
      return window.air.uploadData;
    },
    nextPage() {
      _this.log("===成功调用nextPage===");
    },
    beforePage() {
      _this.log("===成功调用beforePage===");
    },
    jumpPage(page) {
      _this.log(`===成功调用jumpPage=== page == ${page}`);
    },
    sendAnswer(answerObj) {
      _this.log(`===成功调用sendAnswer=== answerObj == ${JSON.stringify(answerObj)}`);
      answerObj.callback && answerObj.callback();
    },
    getAnswer(queryObj, callback) {
      _this.log(`===成功调用getAnswer=== queryObj == ${JSON.stringify(queryObj)}`);
      callback && callback(null);
    },
    getTemplates(callback) {
      _this.log(`===成功调用getTemplates===`);
      callback && callback(null);
    },
    getTemplateUrl(templateName, callback) {
      _this.log(`===成功调用getTemplateUrl=== templateName == ${templateName}`);
      callback && callback(null);
    },
    gameEnd() {
      _this.log(`===成功调用gameEnd===`);
    },
    startRecord(testText) {
      _this.log(`===成功调用startRecord=== testText == ${testText}`);
      this.callOcMethod("startRecord", {"params": testText});
    },
    stopRecord(_isgradepapers, _callback) {
      _this.log(`===成功调用stopRecord=== _isgradepapers == ${_isgradepapers}`);
      let callback = _callback;
      let isgradepapers;
      if(_isgradepapers && typeof _isgradepapers === "function") {
        callback = _isgradepapers;
        isgradepapers = 1;
      } else {
        isgradepapers = _isgradepapers;
      }
      if(!callback){
        // 不传回调函数就表示取消评测
        this.callOcMethod("stopRecord", {isBreak: 1});
        return;
      }
      // 结束录音
      window.air.recordCallBack = (res) => {
        callback && callback(JSON.stringify(res));
        window.air.recordCallBack = null;
      };
      this.callOcMethod("stopRecord", {isBreak: 0, isGradePapers: isgradepapers});
    },
    startTest(testText) {
      _this.log(`===成功调用startTest=== testText == ${testText}`);
      this.callOcMethod("startTest", {"params": testText});
    },
    stopTest(callback) {
      _this.log(`===成功调用stopTest===`);
      if(!callback){
        // 不传回调函数就表示取消评测
        this.callOcMethod("stopTest", {isBreak: 1});
        return;
      }
      // 结束录音
      window.air.testCallBack = (res) => {
        callback && callback(JSON.stringify(res));
        window.air.testCallBack = null;
      };
      this.callOcMethod("stopTest", {});
    },
    openRecognitionCamera(callback) {
      _this.log(`===成功调用openRecognitionCamera===`);
      window.air.recognitionCameraCallBack = (res) => {
        callback && callback(JSON.stringify(res));
        window.air.recognitionCameraCallBack = null;
      };
      this.callOcMethod("openRecognitionCamera", {});
    },
    getEngineInfo(callback) {
      _this.log(`===成功调用getEngineInfo===`);
      // 调用原生获取机器信息
      window.air.getEngineInfoCallback = (res) => {
        callback && callback(JSON.stringify(res));
        window.air.getEngineInfoCallback = null;
      };
      this.callOcMethod("getEngineInfo", {});
    },
    openOsmo() {
      _this.log(`===成功调用openOsmo===`);
      this.callOcMethod("openOsmo", {});
    },
    closeOsmo() {
      _this.log(`===成功调用closeOsmo===`);
      this.callOcMethod("closeOsmo", {});
    },
    openOsmoHandwriting() {
      _this.log(`===成功调用openOsmoHandwriting===`);
      this.callOcMethod("openOsmoHandwriting", {});
    },
    closeOsmoHandwriting() {
      _this.log(`===成功调用closeOsmoHandwriting===`);
      this.callOcMethod("closeOsmoHandwriting", {});
    },
    openOsmoFingerRead() {
      _this.log(`===成功调用openOsmoFingerRead===`);
      this.callOcMethod("openOsmoFingerRead", {});
    },
    closeOsmoFingerRead() {
      _this.log(`===成功调用closeOsmoFingerRead===`);
      this.callOcMethod("closeOsmoFingerRead", {});
    },
    callOcMethod(method, param) {
      const paramStr = JSON.stringify(param);
      _this.log(`===成功调用原生方法${method}===参数==${paramStr}`);
      if (cc.sys.isNative && cc.sys.os == cc.sys.OS_IOS) {
        return jsb.reflection.callStaticMethod('CocosMng', `${method}:`, paramStr);
      } else if (cc.sys.isNative && cc.sys.os == cc.sys.OS_ANDROID) {
        return jsb.reflection.callStaticMethod('com/iplayabc/cocos/AppActivity', method, '(Ljava/lang/String;)Ljava/lang/String;', paramStr);
      } else if (cc.sys.isNative && cc.sys.os == cc.sys.OS_WINDOWS) {
        console.log('汪汪汪')
      } else {
        throw ('非源生环境');
      }
    },
    
  };
}

export function timerManager () {
  window.timerManager = {};
  for(let i=0;i<20;i++){
    window.timerManager[`timer${i}`] = {
      handler: null,
      type: null,
    };
  }

  return {
    freeAll() {
      for (const key in window.timerManager) {
        const obj = window.timerManager[key];
        if(obj.handler){
          window[obj.type](obj.handler);
        }
      }
    }
  }
}
