import {
  buildWebDesktop,
  buildAndroidBundle,
  buildIosBundle,
  buildWebBundle,
  createConfigFile,
  build_check,
  changeSettingsToBundle,
  changeSettingToWebDesktop,
  compressAll,
  replaceIndexHtml,
  replaceUuids
} from "./buildCocos.js";
import { copyDir, removeDir } from "./utils.js";

const startTime = new Date().getTime();

// 构建前检查
const projectName = build_check();

// 清理旧文件
await removeDir('./publish/play');
await removeDir('./publish/form');
await removeDir('./publish/ios');
await removeDir('./publish/android');
await removeDir('./publish/web_desktop');

// 构建form
copyDir('../form/src', 'publish/form');

// 替换uuid
replaceUuids();

// 构建play

// 改设置为非bundle
changeSettingToWebDesktop();

// 构建web_desktop
await buildWebDesktop();

await copyDir('../play/build/web-desktop', 'publish/play');

replaceIndexHtml();

console.log('构建 web desktop 成功！');

// 改设置为bundle
changeSettingsToBundle();

await buildAndroidBundle();

await copyDir('../play/build_android/jsb-link/remote', 'publish/android');

console.log('构建 android bundle 成功！');

await buildIosBundle();

await copyDir('../play/build_ios/jsb-link/remote', 'publish/ios');

console.log('构建 ios bundle 成功！');

await buildWebBundle();

await copyDir(`../play/build_web_desktop/web-desktop/assets/${projectName}`, 'publish/web_desktop');

console.log('构建 web bundle 成功！');

// 改设置为非bundle
changeSettingToWebDesktop();

createConfigFile(projectName);

compressAll(projectName);

const endTime = new Date().getTime();


const duration = new Date(endTime - startTime);
console.log(`打包完成！`);
console.log(`用时${duration.getMinutes()}分${duration.getSeconds()}秒。`);

