cc.Class({
	extends: cc.Component,
	properties: {},

	onLoad() {
		window.courseware = {
			getData(callBack) {
				callBack(null);
				return;
				const uri = 'courseware/v1/getdata';
				const syllabus_id = this.bundleInfoList[this.currentBundleIndex].syllabus_id;
				const data = {
					courseid: syllabus_id
				};
				this.callNetworkApiGet(uri, data, callBack);
			}
		}
	},
	onHomeworkFinish(callBack) {
		return;
		if (this.role == 'teacher') {
			return;
		}
		const uri = 'app_source/v1/student/homework/finished';
		const data = {
			syllabus_id: this.syllabus_id,
			homework_id: this.homework_id,
			token: this.token,
			score: 100
		};
		console.log('data = ' + JSON.stringify(data));
		this.callNetworkApiPost(uri, data, callBack);
	},

	callNetworkApiPost(uri, data, callBack) {
		const xhr = new XMLHttpRequest();
		const url = `${this.baseUrl}${uri}`;
		xhr.open("POST", url, true);
		xhr.setRequestHeader('content-type', 'application/json');
		xhr.onreadystatechange = () => {
			if (xhr.readyState == 4) {
				callBack(JSON.parse(xhr.responseText));
			}
		}
		xhr.send(JSON.stringify(data));
	},

	start() {
		this.node.zIndex = 9999;

		cc.game.addPersistRootNode(this.node);

		this.initListener();


		const addressText = cc.find('middleLayer/ui/address');
		const str = cc.sys.localStorage.getItem('ip');
		console.log('str = ' + str);
		if (str) {
			addressText.getComponent(cc.EditBox).string = str;
		}

		const nameText = cc.find('middleLayer/ui/bundleName');
		const bundleName = cc.sys.localStorage.getItem('bundleName');
		if (bundleName) {
			nameText.getComponent(cc.EditBox).string = bundleName;
		}

		global.middleLayer = cc.find('middleLayer').getComponent('middleLayer');

		middleLayer.log("middleLayer.log('像这样在这里打log')");
	},

	asyncDelayLog(str) {
		console.log(str);
		return new Promise((resolve, reject) => {
			setTimeout(() => {
				resolve();
			}, 1);
		});
	},

	callNetworkApiGet(baseUrl, uri, data, callBack) {
		let queryStr = '?';
		for (const key in data) {
			if (Object.hasOwnProperty.call(data, key)) {
				const value = data[key];
				queryStr += `${key}=${value}`;
			}
		}
		const xhr = new XMLHttpRequest();
		xhr.onreadystatechange = () => {
			if (xhr.readyState == 4 && (xhr.status >= 200 && xhr.status < 400)) {
				callBack(xhr.responseText);
			}
		};
		const url = `${baseUrl}${uri}${queryStr}`;
		console.log('url = ' + url);
		xhr.open('GET', url, true);
		xhr.send();
	},

	initListener() {
		const exitBtn = this.node.getChildByName('ExitBtn');
		exitBtn.on('click', () => {
			cc.tween(exitBtn)
				.to(0.1, { scaleX: 0.9, scaleY: 1.1 })
				.to(0.1, { scaleX: 1.1, scaleY: 0.9 })
				.to(0.1, { scaleX: 1, scaleY: 1 })
				.call(() => {
					cc.game.removePersistRootNode(this.node);
					cc.director.loadScene("middleLayer_for_debug", () => {
						exitBtn.active = false;
					});
				})
				.start();
		});

		const BtnStartLocal = cc.find('middleLayer/ui/BtnStartLocal');
		BtnStartLocal.on('click', () => {
			const addressText = cc.find('middleLayer/ui/address');
			const str = addressText.getComponent(cc.EditBox).string;
			cc.sys.localStorage.setItem('ip', str);
			const address = str.split(':')[0];
			const port = str.split(':')[0] | 8081;
			this.localMode = true;
			this.loadLocalBundle(address, port);
			this.showWaitingLetters();
			this.hideUI();
			exitBtn.active = true;
		});

		const BtnStartOnline = cc.find('middleLayer/ui/BtnStartOnline');
		BtnStartOnline.on('click', () => {
			this.showWaitingLetters();
			this.hideUI();
			const nameText = cc.find('middleLayer/ui/bundleName');
			const bundleName = nameText.getComponent(cc.EditBox).string;
			cc.sys.localStorage.setItem('bundleName', bundleName);
			this.loadOnlineBundle(bundleName);
			exitBtn.active = true;
		});

		const btnClose = cc.find('middleLayer/ConsoleNode/BtnClose');
		const btnOpen = cc.find('middleLayer/ConsoleNode/BtnOpen');
		const consoleNode = cc.find('middleLayer/ConsoleNode/Console');
		const consoleBg = cc.find('middleLayer/ConsoleNode/bg');
		btnOpen.on('click', () => {
			btnClose.active = true;
			btnOpen.active = false;
			consoleNode.active = true;
			consoleBg.active = true;
		});

		btnClose.on('click', () => {
			btnClose.active = false;
			btnOpen.active = true;
			consoleNode.active = false;
			consoleBg.active = false;
		});
	},

	log(str) {
		const logStr = `${new Date().toLocaleString()}: ${str}`;
		console.log(logStr);
		const content = cc.instantiate(cc.find('middleLayer/ConsoleNode/content'));
		content.active = true;
		const label = content.getChildByName('label');
		label.getComponent(cc.Label).string = logStr;
		const consoleContent = cc.find('middleLayer/ConsoleNode/Console/content');
		consoleContent.addChild(content);
		consoleContent.getComponent(cc.Layout).updateLayout();
	},

	hideUI() {
		cc.find('middleLayer/ui').active = false;
	},

	loadOnlineBundle(bundleName) {
		this.callNetworkApiGet(`http://staging-teach.ireadabc.com`, `/api/template/v1/${bundleName}`, {}, (datastr) => {
			const data = JSON.parse(datastr);
			const configData = data.data.conf.android;
			const sceneName = configData.sceneName;
			const version = configData.version;
			const bondleUrl = configData.bondleUrl;
			this.loadBundle(sceneName, version, bondleUrl);
		});
	},

	loadLocalBundle(address, port) {
		this.callNetworkApiGet(`http://${address}:${port}`, '/dist/config.json', {}, (datastr) => {
			const data = JSON.parse(datastr);
			console.log(JSON.stringify(data));
			const sceneName = data.android.sceneName;
			const version = data.android.version;
			const bondleUrl = `http://${address}:${port}/dist/android/${sceneName}/`;
			this.loadBundle(sceneName, version, bondleUrl);
		});
	},

	loadBundle(sceneName, version, bondleUrl) {
		cc.assetManager.loadBundle(bondleUrl, { version: version }, async (err, bundle) => {
			if (err) {
				return this.asyncDelayLog(err);
			}
			bundle.loadScene(sceneName, (err, scene) => {
				if (err) {
					this.asyncDelayLog('err: ', err);
				}
				this.hideWaitingLetters();
				cc.director.runScene(scene);
			});
		});
	},

	callNativeFunction(param) {
		const paramStr = JSON.stringify(param);
		if (cc.sys.isNative && cc.sys.os == cc.sys.OS_IOS) {
			return jsb.reflection.callStaticMethod('CocosMng', 'cocosWithNativeProtocol:', paramStr);
		} else if (cc.sys.isNative && cc.sys.os == cc.sys.OS_ANDROID) {
			return jsb.reflection.callStaticMethod('com/iplayabc/cocos/AppActivity', 'cocosWithNativeProtocol', '(Ljava/lang/String;)Ljava/lang/String;', paramStr);
		} else if (cc.sys.isNative && cc.sys.os == cc.sys.OS_WINDOWS) {
			console.log('汪汪汪')
		} else {
			throw ('非源生环境');
		}
	},

	showWaitingLetters() {
		const colorList = this.getRainbowColorList();
		const layout = cc.find('middleLayer/layout');
		// layout.active = true;
		const str = 'Now Loading...';
		str.split('').forEach((word, idx) => {
			const node = new cc.Node();
			const label = node.addComponent(cc.Label);
			label.string = word;
			node.parent = layout;
			node.color = colorList[idx];
			cc.tween(node)
				.delay(idx / 4)
				.by(0.3, { y: 50 }, { easing: 'sineOut' })
				.by(0.3, { y: -50 }, { easing: 'sineIn' })
				.delay((str.length - idx) / 4)
				.union()
				.repeatForever()
				.start();
		});
		const totalWidth = layout.children.reduce((width, node, idx) => {
			return width + node.width;
		}, 0);
		layout.width = totalWidth;
	},

	hideWaitingLetters() {
		const layout = cc.find('middleLayer/layout');
		layout.active = false;
	},

	showLog(str) {
		if (!this.logList) {
			this.logList = [];
		}
		this.logList.push(str);
		console.log(str);

		if (this.logList.length == 1) {
			this.showOneLog();
		}
	},

	showOneLog() {
		const str = this.logList[0];
		if (str === undefined) {
			return;
		}
		const node = new cc.Node();
		node.anchorX = 0.5;
		const label = node.addComponent(cc.RichText);
		label.string = `<outline color=black width=3>${str}</outline>`;
		label.maxWidth = this.node.width / 2;
		node.x = this.node.width / 4;
		node.y = -this.node.height / 2;
		node.parent = this.node;
		cc.tween(node)
			.to(5, { y: this.node.height })
			.removeSelf()
			.start();
		setTimeout(() => {
			this.logList.shift();
			this.showOneLog();
		}, 1000);
	},

	getRainbowColorList() {
		return [
			cc.color(255, 255, 0),
			cc.color(128, 255, 0),
			cc.color(0, 255, 0),
			cc.color(0, 0, 0),

			cc.color(0, 255, 128),
			cc.color(0, 255, 255),

			cc.color(0, 128, 255),
			cc.color(0, 0, 255),
			cc.color(128, 0, 255),
			cc.color(255, 0, 255),
			cc.color(255, 0, 128),

			cc.color(255, 0, 0),
			cc.color(255, 128, 0),
			cc.color(255, 255, 0),
		];
	}
});
