## 接口信息

### 获取基本信息
```
PSQS_get_basic_info
```

#### 参数
无

#### 返回
```javascript
{ 
  version: 'bata 0.9.7', // 屏幕最下方的版本号
  privacyPolicyUrl: 'http://www.baidu.com', // 弹出webView
  userAgreement: 'http://www.baidu.com', // 弹出webView
}
```



### 获取验证码
```javascript
PSQS_get_pass_code
```

#### 参数：

| 参数名 | 类型   | 说明           |
| ------ | ------ | -------------- |
| phone  | number | 输入的手机号码 |

#### 返回：
```javascript
{success: true, msg: ''} 
```

```javascript
{success: false, msg: '请输入正确的手机号码。'} 
```

### 登陆/注册
```javascript
PSQS_login
```

#### 参数：

| 参数名 | 类型   | 说明     |
| ------ | ------ | -------- |
| phone  | number | 手机号码 |
| code   | string | 验证码   |

#### 返回：
```javascript
{ 
  msg: '',
  success: true,
  userInfo: { // userInfo为空时弹出填写用户信息的页面
    phone: 13812345678,
    nickName: "小豆梓",
    sex: "girl",
    provice: "辽宁省",
    city: "大连市",
    age: '5~8岁',
    grade: '一年级'
  },
  bookInfo: [{
    name: "kind_A",
    bookList: [{
      id: 12334,
      coverImg: "http://staging-teach.cdn.ireadabc.com/0d332cb2b167feb4204b1d77a6f02ed6.jpg",
      duration: "21:33",
      rate: "55%",
      createDate: "2012-12-21"
    }, {
      id: 12231,
      coverImg: "http://staging-teach.cdn.ireadabc.com/0d332cb2b167feb4204b1d77a6f02ed6.jpg",
      duration: "21:33",
      readTime: 2,
      createDate: "2012-12-21"
    }],
  }, {
    name: "kind_B",
    bookList: [{
      id: 12235,
      coverImg: "http://staging-teach.cdn.ireadabc.com/0d332cb2b167feb4204b1d77a6f02ed6.jpg",
      duration: "21:33",
      readTime: 1,
      createDate: "2012-12-21"
    }],
  }]}
```


```javascript
{success: false, msg: '请输入正确的手机号码。'} 
```

### 保存用户信息
```
PSQS_set_user_info
```
#### 参数
| 参数名   | 类型   | 说明                  |
| -------- | ------ | --------------------- |
| phone    | number | 手机号码              |
| nickName | string | 昵称                  |
| sex      | string | 性别（boy 或者 girl） |
| provice  | string | 省                    |
| city     | string | 市                    |
| age      | string | 年龄                  |
| grade    | string | 年级                  |

#### 返回：
```javascript
{success: true, msg: ''} 
```
```javascript
{success: false, msg: '错误信息'} 
```


### 扫描二维码
```
PSQS_scan_code
```
#### 参数
无
#### 返回
```javascript
{
  success: true,
  bookInfo: [{
    name: "kind_A",
    bookList: [{
      id: 12334,
      coverImg: "http://staging-teach.cdn.ireadabc.com/0d332cb2b167feb4204b1d77a6f02ed6.jpg",
      duration: "21:33",
      rate: "0%",
      createDate: "2012-12-21"
    }],
  }, {
    name: "kind_B",
    bookList: [],
  }]
}
```
```javascript
{success: false, msg: '错误信息'} 
```

### 进入课件
```
PSQS_read_book
```
#### 参数
| 参数名 | 类型   | 说明   |
| ------ | ------ | ------ |
| bookId | number | 课件id |

#### 返回：
```javascript
{success: true, msg: ''} 
```
```javascript
{success: false, msg: '错误信息'} 
```

### 登出
```
PSQS_logout
```
#### 参数
无

#### 返回：
```javascript
{success: true, msg: ''} 
```
```javascript
{success: false, msg: '错误信息'} 
```

### 获取省份名
```
PSQS_get_province
```
#### 参数
| 参数名    | 类型    | 说明   |
| -------- | ------ | ------ |
| province | string | 省份名  |

#### 返回：
```javascript
['北京','上海']
```

### 获取城市名
```
PSQS_get_city
```
#### 参数
无

#### 返回：
```javascript
['北京市','上海市']
```