import { initAir } from './air';
cc.Class({
	extends: cc.Component,
	properties: {
	},

	callNetworkApiPost(baseUrl, uri, data, callBack) {
		this.getBaseUrl((baseUrl) => {
			const xhr = new XMLHttpRequest();
			const url = `${baseUrl}${uri}`;
			xhr.open("POST", url, true);
			xhr.setRequestHeader('content-type', 'application/json');
			xhr.onreadystatechange = () => {
				if (xhr.readyState == 4) {
					callBack(JSON.parse(xhr.responseText));
				}
			}
			xhr.send(JSON.stringify(data));
		});
	},

	callNetworkApiGet(baseUrl, uri, data, callBack) {
		this.getBaseUrl((baseUrl) => {
			let queryStr = '?';
			const params = [];
			for (const key in data) {
				if (Object.hasOwnProperty.call(data, key)) {
					params.push(`${key}=${data[key]}`);
				}
			}
			queryStr += params.join("&");
			const xhr = new XMLHttpRequest();
			xhr.onreadystatechange = () => {
				if (xhr.readyState == 4 && (xhr.status >= 200 && xhr.status < 400)) {
					callBack(xhr.responseText);
				}
			};
			const url = `${baseUrl}${uri}${queryStr}`;
			console.log('url = ' + url);
			xhr.open('GET', url, true);
			xhr.send();
		});
	},

	callNetworkApiGetLocal(baseUrl, uri, data, callBack) {
		let queryStr = '?';
		const params = [];
		for (const key in data) {
			if (Object.hasOwnProperty.call(data, key)) {
				params.push(`${key}=${data[key]}`);
			}
		}
		queryStr += params.join("&");
		const xhr = new XMLHttpRequest();
		xhr.onreadystatechange = () => {
			if (xhr.readyState == 4 && (xhr.status >= 200 && xhr.status < 400)) {
				callBack(xhr.responseText);
			}
		};
		const url = `${baseUrl}${uri}${queryStr}`;
		console.log('url = ' + url);
		xhr.open('GET', url, true);
		xhr.setRequestHeader('Access-Control-Request-Private-Network', true);
		xhr.send();
	},

	// 需要预加载的数量
	preloadCount: null,
	// 统计已加载的数量
	loadedCount: null,

	// 统一释放异步资源的方法
	onLoad() {
		this.preloadCount = 0;
		this.loadedCount = 0;
		const uiNode = cc.find('middleLayer/ui');
		uiNode.parent.getComponent(cc.Widget).updateAlignment();
		const scale = Math.min(
			uiNode.parent.width / uiNode.width,
			uiNode.parent.height / uiNode.height,
		)
		uiNode.scale = scale;
		initAir(this);
		// this.preloadAll();

		this.role = 'student';
	},

	getBaseUrl(callback) {
		if (window.air.engineInfo) {
			const { isDev } = JSON.parse(window.air.engineInfo);
			if (isDev == 1) {
				callback('https://staging-teach.ireadabc.com');
			} else {
				callback('https://iteachabc.com');
			}
		} else {
			window.courseware.getEngineInfo(() => {
				const { isDev } = JSON.parse(window.air.engineInfo);
				if (isDev == 1) {
					callback('https://staging-teach.ireadabc.com');
				} else {
					callback('https://iteachabc.com');
				}
			});
		}
	},

	start() {
		this.node.zIndex = 9999;
		cc.game.addPersistRootNode(this.node);
		this.initListener();

		const addressText = cc.find('middleLayer/ui/address');
		const str = cc.sys.localStorage.getItem('ip');
		console.log('str = ' + str);
		if (str) {
			addressText.getComponent(cc.EditBox).string = str;
		}

		const nameText = cc.find('middleLayer/ui/bundleName');
		const bundleName = cc.sys.localStorage.getItem('bundleName');
		if (bundleName) {
			nameText.getComponent(cc.EditBox).string = bundleName;
		}

		const courseIdNode = cc.find('middleLayer/ui/courseId');
		const courseId = cc.sys.localStorage.getItem('courseId');
		if (courseId) {
			courseIdNode.getComponent(cc.EditBox).string = courseId;
		}

		global.middleLayer = cc.find('middleLayer').getComponent('middleLayer');

		middleLayer.log("middleLayer.log('像这样在这里打log')");
	},

	preloadAll() {
		if (window.preloadBundleAndSourcesFlag) {
			// 只加载一次就行了
			return;
		}
		window.preloadBundleAndSourcesFlag = true;
		cc.find("middleLayer/ui/ProgressLabel").active = true;
		cc.find('middleLayer/ui/loadingProgress').active = true;
		let platform = "web_desktop";
		if (cc.sys.os == cc.sys.OS_IOS) {
			platform = "ios";
		} else if (cc.sys.os == cc.sys.OS_ANDROID) {
			platform = "android";
		}
		this.callNetworkApiGet(`http://staging-teach.ireadabc.com`, `/api/syllabus/v1/allbundles`, { orgid: 483, platform }, (datastr) => {
			const data = JSON.parse(datastr);
			if (data.rows && data.rows.length > 0) {
				this.preloadCount += data.rows.length;
			}
			this.callNetworkApiGet(`http://staging-teach.ireadabc.com`, `/api/syllabus/v1/allresources`, { orgid: 483 }, (datastr1) => {
				const data1 = JSON.parse(datastr1);
				if (data1.rows && data1.rows.length > 0) {
					this.preloadCount += data1.rows.length;
				}
				console.log('data.rows = ' + JSON.stringify(data.rows));
				this.batchPreloadScene(data.rows);
				this.preloadSource(data1.rows);
			});
		});
	},

	preloadSourceImman() {
		// 测试用
		cc.find("middleLayer/ui/ProgressLabel").active = true;
		cc.find('middleLayer/ui/loadingProgress').active = true;
		this.callNetworkApiGet(`http://staging-teach.ireadabc.com`, `/api/courseware/v1/getresources`, { courseid: 20894 }, (datastr1) => {
			const data1 = JSON.parse(datastr1);
			if (data1.rows && data1.rows.length > 0) {
				this.preloadCount += data1.rows.length;
			}
			this.log('data1.rows = ' + JSON.stringify(data1.rows));
			this.preloadSource(data1.rows);
		});
	},

	batchPreloadScene(scenes = []) {
		const expects = [
			// 'op_03_2',  
			// 'OP10_online', 
		];
		const _this = this;
		let i = 0;
		const load = function () {
			const scene = scenes[i];
			if (expects.includes(scene.sceneName)) {
				_this.loadedCount++;
				_this.updateProcessBar();
				i++;
				if (i < scenes.length) {
					setTimeout(() => {
						load();
					}, 1);
				}
				return;
			}
			cc.assetManager.loadBundle(scene.bondleUrl, { version: scene.version }, (err, bundle) => {
				console.log(`${scene.bondleUrl}---场景开始loadBundle----`);
				if (!bundle) {
					_this.loadedCount++;
					_this.updateProcessBar();
					i++;
					if (i < scenes.length) {
						setTimeout(() => {
							load();
						}, 1);
					}
					return;
				}
				bundle.preloadScene(scene.sceneName, () => { }, () => {
					console.log(`${scene.sceneName}场景预加载结束`);
					_this.loadedCount++;
					_this.updateProcessBar();
					i++;
					if (i < scenes.length) {
						setTimeout(() => {
							load();
						}, 1);
					}
				});
			});
		}

		if (scenes && scenes.length > 0) {
			load();
		}
	},

	preloadSource(array) {
		const rows = array || [];
		const batchLoad = () => {
			let tempArr = rows.splice(0, 10);
			let len = tempArr.length;
			for (let i = 0; i < tempArr.length; i++) {
				cc.assetManager.loadRemote(tempArr[i], (err, texture) => {
					if (err) {
						console.log(err)
					}
					this.loadedCount++;
					this.updateProcessBar();
					if (i === len - 1) {
						batchLoad();
					}
				});
			}
		}
		batchLoad();
	},

	updateProcessBar() {
		const label = cc.find("middleLayer/ui/ProgressLabel").getComponent(cc.Label);
		const loadingProgress = cc.find('middleLayer/ui/loadingProgress');
		label.string = `正在加载：${this.loadedCount} / ${this.preloadCount}`;
		if (this.loadedCount > this.preloadCount * 0.99) {
			cc.find("middleLayer/ui/ProgressLabel").active = false;
			loadingProgress.active = false;
			this.showLog("资源全部加载完成");
		}
		loadingProgress.getComponent(cc.ProgressBar).progress = this.loadedCount / this.preloadCount;
	},

	onHomeworkFinish(callBack, data = null) {
		console.log('this.courseIndex = ' + JSON.stringify(this.currentBundleInfo));
		if (this.currentBundleInfo.sceneName == 'ls_fly') {
			const rightCount = data.reduce((preValue, right) => {
				if (right) {
					return preValue + 1;
				} else {
					return preValue;
				}
			}, 0);
			console.log('rightCount = ' + rightCount);
		}
		console.log('onHomeworkFinish: ' + JSON.stringify(data));
	},

	callMiddleLayerFunction(apiName, data, callback) {
		switch (apiName) {
			case 'NS_login':
				if (data.userName == 'admin' && data.password == '123456') {
					this.showLog('登录成功！');
					callback('登录成功！');
				} else {
					this.showLog('密码错误！');
					callback('密码错误！');
				}
				break;
			case 'NS_logout':
				this.showLog('登出成功！');
				callback('登出成功！');
				break;
			case 'NS_select_book':
				if (data.bookId == 10001) {
					this.showLog('选择剧本: ' + data.bookId);
					callback('选择剧本: ' + data.bookId);
				} else {
					this.showLog('剧本未解锁！');
					callback('剧本未解锁！');
				}
				break;
			case 'NS_select_stage':
				if (data.stageId == 10011) {
					this.showLog('选择关卡: ' + data.stageId);
					callback('选择关卡: ' + data.stageId);
				} else {
					this.showLog('关卡未解锁！');
					callback('关卡未解锁！');
				}
				break;
			case 'NS_select_event':
				this.showLog('选择活动：' + data.eventId);
				callback('选择活动：' + data.eventId);
				break;
			case 'NS_select_game':
				this.showLog('选择游戏: ' + data.gameId);
				callback('选择游戏: ' + data.gameId);
				break;
			case 'PSQS_get_pass_code':
				this.showLog('获取验证码: ' + data.phone);
				if (Math.random() > 0.5) {
					callback({ success: true });
				} else {
					callback({ success: false, msg: '请输入正确的手机号码。' });
				}
				break;
			case 'PSQS_login':
				this.showLog(`登录/注册: ${data.phone} ${data.code}`);
				const number = Math.random();
				if (number > 0.6) {
					callback({
						success: true,
						userInfo: { // userInfo为空时弹出填写用户信息的页面
							phone: 13812345678,
							nickName: "小豆梓",
							sex: "girl",
							provice: "辽宁省",
							city: "大连市",
							age: '5~8岁',
							grade: '一年级'
						},
						bookInfo: [{
							name: "kind_A",
							bookList: [{
								id: 12334,
								coverImg: "http://staging-teach.cdn.ireadabc.com/0d332cb2b167feb4204b1d77a6f02ed6.jpg",
								duration: "21:33",
								rate: "55%",
								createDate: "2012-12-21"
							}, {
								id: 12231,
								coverImg: "http://staging-teach.cdn.ireadabc.com/0d332cb2b167feb4204b1d77a6f02ed6.jpg",
								duration: "21:33",
								readTime: 2,
								createDate: "2012-12-21"
							}],
						}, {
							name: "kind_B",
							bookList: [{
								id: 12235,
								coverImg: "http://staging-teach.cdn.ireadabc.com/0d332cb2b167feb4204b1d77a6f02ed6.jpg",
								duration: "21:33",
								readTime: 1,
								createDate: "2012-12-21"
							}],
						}]
					});
				} else if (number > 0.3) {
					callback({
						success: true,
						userInfo: null, // userInfo为空时弹出填写用户信息的页面 
						bookInfo: [{
							name: "kind_A",
							bookList: [{
								id: 12334,
								coverImg: "http://staging-teach.cdn.ireadabc.com/0d332cb2b167feb4204b1d77a6f02ed6.jpg",
								duration: "21:33",
								rate: "55%",
								createDate: "2012-12-21"
							}, {
								id: 12231,
								coverImg: "http://staging-teach.cdn.ireadabc.com/0d332cb2b167feb4204b1d77a6f02ed6.jpg",
								duration: "21:33",
								readTime: 2,
								createDate: "2012-12-21"
							}],
						}, {
							name: "kind_B",
							bookList: [{
								id: 12235,
								coverImg: "http://staging-teach.cdn.ireadabc.com/0d332cb2b167feb4204b1d77a6f02ed6.jpg",
								duration: "21:33",
								readTime: 1,
								createDate: "2012-12-21"
							}],
						}]
					});
				} else {
					callback({ success: false, msg: '验证码错误。' });
				}
				break;
			case 'PSQS_set_user_info':
				this.showLog(`设置用户信息: ${JSON.stringify(data)}`);
				if (Math.random() > 0.5) {
					callback({ success: true });
				} else {
					callback({ success: false, msg: '错误信息' });
				}
				break;
			case 'PSQS_scan_code':
				this.showLog(`扫码`);
				if (Math.random() > 0.5) {
					callback({
						success: true,
						bookInfo: [{
							name: "kind_A",
							bookList: [{
								id: 12334,
								coverImg: "http://staging-teach.cdn.ireadabc.com/0d332cb2b167feb4204b1d77a6f02ed6.jpg",
								duration: "21:33",
								rate: "0%",
								createDate: "2012-12-21"
							}],
						}, {
							name: "kind_B",
							bookList: [],
						}]
					});
				} else {
					callback({ success: false, msg: '错误信息' });
				}
				break;
			case 'PSQS_read_book':
				this.showLog('进入课件: ' + data.bookId);
				if (Math.random() > 0.5) {
					callback({ success: true });
				} else {
					callback({ success: false, msg: '请输入正确的手机号码。' });
				}
				break;
			case 'PSQS_get_basic_info':
				this.showLog('获取基本信息');
				callback({
					version: 'bata 0.9.7',
					privacyPolicyUrl: 'http://www.baidu.com',
					userAgreement: 'http://www.baidu.com',
				});
				break;
			case 'PSQS_play_animate_over':
				break;
			case 'PSQS_jump_to_question':
				break;
			case 'PSQS_get_course_info':
				this.showLog('获取播放骨骼动画模板的信息');
				const returnData = {
					first: false, // 是不是第一个模板
					last: false, // 是不是最后一个模板
					playTime: 0, // 播放了几次 0：不需要跳题 1：需要跳题
					saveData: {}
				}
				callback(returnData);
				break;
			case 'PSQS_show_rabbit':
				break;
			case 'PSQS_hide_rabbit':
				break;
			default:
				this.showLog('未定义接口: ' + apiName);
				break;
		}
	},

	asyncDelayLog(str) {
		console.log(str);
		return new Promise((resolve, reject) => {
			setTimeout(() => {
				resolve();
			}, 1);
		});
	},

	initListener() {
		const exitBtn = cc.find('middleLayer/ExitBtn');
		exitBtn.on('click', () => {
			cc.find('middleLayer/BtnRight').active = false;
			cc.find('middleLayer/BtnLeft').active = false;

			cc.tween(exitBtn)
				.to(0.1, { scaleX: 0.4, scaleY: 0.6 })
				.to(0.1, { scaleX: 0.6, scaleY: 0.4 })
				.to(0.1, { scaleX: 0.5, scaleY: 0.5 })
				.call(() => {
					exitBtn.active = false;
					cc.game.removePersistRootNode(this.node);
					// cc.director.getScene().destroy();
					cc.audioEngine.stopAll();
					window.courseware.freeAllOcMethod();
					const flag = cc.director.loadScene("debug_shell", null, null, (err, scene) => {
					});
					if (!flag) {
						// 没有壳的情况下，直接加载中间层场景
						cc.director.loadScene("middleLayer_for_debug", null, null, (err, scene) => {
						});
					}
				})
				.start();
		});

		cc.find('middleLayer/BtnRight').on('click', () => {
			this.goNextPage();
		});

		cc.find('middleLayer/BtnLeft').on('click', () => {
			this.goPrePage();
		});

		cc.find('middleLayer/ui/BtnOpenOsmo').on('click', () => {
			window.courseware.openOsmo();
		});

		cc.find('middleLayer/ui/BtnCloseOsmo').on('click', () => {
			window.courseware.closeOsmo();
		});

		cc.find('middleLayer/ui/BtnOpenRecord').on('click', () => {
			window.courseware.startRecord(1);
		});

		cc.find('middleLayer/ui/BtnCloseRecord').on('click', () => {
			window.courseware.stopRecord(res => {
				this.log('--------录音返回结果 stopRecord ------------');
				this.log(res)
				this.log('------------------------------');
				this.log(`录音的文本是${JSON.parse(res).text}`);
				this.log(`录音的音频URL是${JSON.parse(res).audioUrl}`);
			});
		});

		cc.find('middleLayer/ui/BtnOpenTest').on('click', () => {
			window.courseware.startTest('apple');
		});

		cc.find('middleLayer/ui/BtnCloseTest').on('click', () => {
			window.courseware.stopTest(res => {
				this.log('--------录音评测返回结果 stopTest ---------');
				this.log(res)
				this.log('------------------------------');
				this.log(`录音apple的评分是${JSON.parse(res).result.overall}`);
				this.log(`录音apple的音频URL是${JSON.parse(res).audioUrl}`);
			});
		});

		const BtnStartLocal = cc.find('middleLayer/ui/BtnStartLocal');
		BtnStartLocal.on('click', () => {
			const addressText = cc.find('middleLayer/ui/address');
			const str = addressText.getComponent(cc.EditBox).string;
			cc.sys.localStorage.setItem('ip', str);
			const address = str.split(':')[0];
			const port = str.split(':')[0] | 8081;
			this.localMode = true;
			this.loadLocalBundle(address, port);
			this.showWaitingLetters();
			this.hideUI();
			this.showDebugUI();
		});

		const BtnStartOnline = cc.find('middleLayer/ui/BtnStartOnline');
		BtnStartOnline.on('click', () => {
			const nameText = cc.find('middleLayer/ui/bundleName');
			const bundleName = nameText.getComponent(cc.EditBox).string;
			cc.sys.localStorage.setItem('bundleName', bundleName);
			this.loadOnlineBundle(bundleName);
			this.showDebugUI();
		});

		const BtnStartCourseWare = cc.find('middleLayer/ui/BtnStartCourseWare');
		BtnStartCourseWare.on('click', () => {
			const courseIdNode = cc.find('middleLayer/ui/courseId');
			const courseId = courseIdNode.getComponent(cc.EditBox).string;
			cc.sys.localStorage.setItem('courseId', courseId);
			this.loadOnlineCourseWare(courseId);
			this.showDebugUI();
		});

		const BtnLoad = cc.find('middleLayer/ui/BtnLoad');
		BtnLoad.on('click', () => {

			// 测试获取设备信息
			window.courseware.getEngineInfo(res => {
				this.log('--------getEngineInfo返回结果---------');
				this.log(res)
				this.log('------------------------------');
			});

			// 测试预加载资源
			// this.preloadCount = 0;
			// this.loadedCount = 0;
			// cc.find("middleLayer/ui/ProgressLabel").active = true;
			// cc.find('middleLayer/ui/loadingProgress').active = true;
			// // this.preloadAll();
			// this.preloadSourceImman();
		});

		const btnClose = cc.find('middleLayer/ConsoleNode/BtnClose');
		const btnOpen = cc.find('middleLayer/ConsoleNode/BtnOpen');
		const consoleNode = cc.find('middleLayer/ConsoleNode/Console');
		const consoleBg = cc.find('middleLayer/ConsoleNode/bg');
		btnOpen.on('click', () => {
			btnClose.active = true;
			btnOpen.active = false;
			consoleNode.active = true;
			consoleBg.active = true;
		});

		btnClose.on('click', () => {
			btnClose.active = false;
			btnOpen.active = true;
			consoleNode.active = false;
			consoleBg.active = false;
		});
	},

	goPrePage() {
		this.goTarIndexPage(this.courseIndex - 1);
	},
	goNextPage() {
		this.goTarIndexPage(this.courseIndex + 1);
	},
	goTarIndexPage(index) {
		if (!this.courses || index == this.courseIndex || index < 0 || index > this.courses.length - 1) {
			return;
		}

		window.courseware.freeAllOcMethod();

		this.courseIndex = index;
		this.courseItem = this.courses[this.courseIndex];
		if (this.courseIndex == 0) {
			cc.find('middleLayer/BtnLeft').active = false;
		} else {
			cc.find('middleLayer/BtnLeft').active = false;
		}
		if (this.courseIndex == this.courses.length - 1) {
			cc.find('middleLayer/BtnRight').active = false;
		} else {
			cc.find('middleLayer/BtnRight').active = true;
		}
		this.loadPageBundle();
	},
	log(str) {
		const logStr = `${new Date().toLocaleString()}: ${str}`;
		console.log(logStr);
		const content = cc.instantiate(cc.find('middleLayer/ConsoleNode/content'));
		content.active = true;
		const label = content.getChildByName('label');
		label.getComponent(cc.Label).string = logStr;
		const consoleContent = cc.find('middleLayer/ConsoleNode/Console/content');
		consoleContent.addChild(content);
		consoleContent.getComponent(cc.Layout).updateLayout();
	},
	hideUI() {
		cc.find('middleLayer/ui').active = false;
	},
	loadOnlineBundle(bundleName) {
		this.hideUI();
		this.showWaitingLetters();
		this.callNetworkApiGet(`http://staging-teach.ireadabc.com`, `/api/template/v1/${bundleName}`, {}, (datastr) => {
			const data = JSON.parse(datastr);
			let configData = null;
			if (cc.sys.os == cc.sys.OS_IOS) {
				configData = data.data.conf.ios;
			} else if (cc.sys.os == cc.sys.OS_ANDROID) {
				configData = data.data.conf.android;
			} else {
				configData = data.data.conf.web_desktop;
			}
			const sceneName = configData.sceneName;
			const version = configData.version;
			const bondleUrl = configData.bondleUrl;
			this.loadBundle(sceneName, version, bondleUrl);
		});
	},
	courses: null,
	courseIndex: 0,
	courseItem: null,
	loadOnlineCourseWare(courseId, linkFlag) {
		this.hideUI();
		this.showWaitingLetters();

		let api = `/api/courseware/v1/${courseId}/list`;
		if (linkFlag === true) {
			api = `/api/courseware/v1/${courseId}/eq/level/list`;
		}
		this.callNetworkApiGet(`http://staging-teach.ireadabc.com`, api, {}, (datastr) => {
			const data = JSON.parse(datastr);
			if (data.rows && data.rows.length > 0) {
				this.courses = data.rows;
				this.courseIndex = data.index || 0;
				this.courseItem = data.rows[this.courseIndex];
			}
			if (this.courses && this.courses.length > 1 && this.courseIndex <= this.courses.length - 1) {
				cc.find('middleLayer/BtnRight').active = true;
			}
			if (this.courseIndex > 0) {
				cc.find('middleLayer/BtnLeft').active = false;
			}
			this.reWriteAir();
			this.loadPageBundle();
		});
	},
	loadLocalBundle(address, port) {
		this.callNetworkApiGetLocal(`http://${address}:${port}`, '/dist/config.json', {}, (datastr) => {
			const data = JSON.parse(datastr);
			let sceneName = '';
			let version = '';
			let bondleUrl = '';
			if (cc.sys.os == cc.sys.OS_IOS) {
				sceneName = data.ios.sceneName;
				version = data.ios.version;
				bondleUrl = `http://${address}:${port}/dist/ios/${sceneName}/`;
			} else if (cc.sys.os == cc.sys.OS_ANDROID) {
				sceneName = data.android.sceneName;
				version = data.android.version;
				bondleUrl = `http://${address}:${port}/dist/android/${sceneName}/`;
			} else {
				sceneName = data.android.sceneName;
				version = "";
				bondleUrl = `http://${address}:${port}/dist/web_desktop/`;
			}
			this.loadBundle(sceneName, version, bondleUrl);
		});
	},
	loadPageBundle() {
		let sceneName, version, bondleUrl = "";
		if (cc.sys.os == cc.sys.OS_IOS) {
			sceneName = this.courseItem.conf.ios.sceneName;
			version = this.courseItem.conf.ios.version;
			bondleUrl = this.courseItem.conf.ios.bondleUrl;
		} else if (cc.sys.os == cc.sys.OS_ANDROID) {
			sceneName = this.courseItem.conf.android.sceneName;
			version = this.courseItem.conf.android.version;
			bondleUrl = this.courseItem.conf.android.bondleUrl;
		} else {
			sceneName = this.courseItem.conf.web_desktop.sceneName;
			version = this.courseItem.conf.web_desktop.version;
			bondleUrl = this.courseItem.conf.web_desktop.bondleUrl;
		}

		this.loadBundle(sceneName, version, bondleUrl);
	},
	loadBundle(sceneName, version, bondleUrl) {
		this.currentBundleInfo = { sceneName, version, bondleUrl };
		this.showMask();
		this.showWaitingLetters();
		cc.assetManager.loadBundle(bondleUrl, { version: version }, async (err, bundle) => {
			if (err) {
				return this.asyncDelayLog(err);
			}
			bundle.loadScene(sceneName, null, null, (err, scene) => {
				if (err) {
					this.asyncDelayLog('err: ', err);
				}
				cc.audioEngine.stopAll();
				cc.director.runScene(scene, null, () => {
					console.log('sceneName = ' + sceneName);
					const canvas = cc.find('Canvas');
					const middleLayer = cc.find('middleLayer');
					cc.find('middleLayer/ExitBtn').active = true;
					this.hideWaitingLetters();
					this.hideMask();
					canvas.getComponent(cc.Widget).updateAlignment();
					middleLayer.scale = canvas.width / middleLayer.width;
					// this.showLog('middleLayer.scale = ' + middleLayer.scale);
				});
			});
		});
	},

	reloadBundle() {
		const { sceneName, version, bondleUrl } = this.currentBundleInfo;

		this.loadBundle(sceneName, version, bondleUrl);
	},

	showMask() {
		const mask = cc.find('middleLayer/mask');
		mask.active = true;
		cc.tween(mask)
			.set({ opacity: 0 })
			.to(0.5, { opacity: 0 })
			.start();
	},

	hideMask() {
		const mask = cc.find('middleLayer/mask');
		mask.stopAllActions();
		cc.tween(mask)
			.set({ opacity: 0 })
			.to(0.5, { opacity: 0 })
			.call(() => {
				mask.active = false;
			})
			.start();
	},

	reWriteAir() {
		window.courseware.getData = (callback) => {
			let data = null;
			if (this.courseItem.data) {
				data = JSON.parse(this.courseItem.data);
			}
			this.log("===成功调用getData===" + this.courseItem.data);
			callback && callback(data);
		}
		window.courseware.nextPage = () => {
			this.goNextPage();
		}
		window.courseware.beforePage = () => {
			this.goPrePage();
		}
		window.courseware.sendAnswer = (answerObj) => {
			this.log("===成功调用sendAnswer===" + JSON.stringify(answerObj));
			this.callNetworkApiPost(`http://staging-teach.ireadabc.com`, `/api/oxford/courseware/v1/${this.courseItem.id}/saveanswer`, answerObj, (data) => {
				answerObj.callback && answerObj.callback(JSON.stringify(data.row));
			});
		}
		window.courseware.getAnswer = (queryObj, callback) => {
			this.log("===成功调用getAnswer===" + JSON.stringify(queryObj));
			this.callNetworkApiGet(`http://staging-teach.ireadabc.com`, `/api/oxford/courseware/v1/${this.courseItem.id}/getanswer`, queryObj, (datastr) => {
				const data = JSON.parse(datastr);
				callback && callback(JSON.stringify(data.rows));
			});
		}
	},

	callNativeFunction(param) {
		const paramStr = JSON.stringify(param);
		if (cc.sys.isNative && cc.sys.os == cc.sys.OS_IOS) {
			return jsb.reflection.callStaticMethod('CocosMng', 'cocosWithNativeProtocol:', paramStr);
		} else if (cc.sys.isNative && cc.sys.os == cc.sys.OS_ANDROID) {
			return jsb.reflection.callStaticMethod('com/iplayabc/cocos/AppActivity', 'cocosWithNativeProtocol', '(Ljava/lang/String;)Ljava/lang/String;', paramStr);
		} else if (cc.sys.isNative && cc.sys.os == cc.sys.OS_WINDOWS) {
			console.log('汪汪汪')
		} else {
			console.error('非源生环境11');
		}
	},



	showWaitingLetters() {

		if (this.isShowWaiting) {
			return;
		}
		this.isShowWaiting = true;

		const layout = cc.find('middleLayer/layout');
		layout.removeAllChildren();

		const canvas = cc.find("Canvas");
		const bg = layout.addComponent(cc.Graphics);
		bg.fillRect(-canvas.width / 2, -canvas.height / 2, canvas.width, canvas.height);


		const laodingLayer = cc.find('middleLayer/loadingLayer');
		laodingLayer.active = true;
		// const loading = cc.find('middleLayer/loadingLayer/loading');
		// const anim = loading.getComponent(cc.Animation)
		// anim.play('loading')

		const script = cc.find('middleLayer/loadingLayer/progress').getComponent('progressScript');
		script.setProgress(0);

		const id = setInterval(() => {
			// console.log('changeObj.value: ', changeObj.value);
			script.setProgress(changeObj.value);
		}, 1);

		const changeObj = { value: 0 };
		cc.tween(changeObj)
			.to(5, { value: 0.9 })
			.call(() => {
				clearInterval(id);
			})
			.start();



		// const colorList = this.getRainbowColorList();
		// const layout = cc.find('middleLayer/layout');
		// layout.removeAllChildren();
		// layout.active = true;
		// const str = 'Now Loading...';
		// str.split('').forEach((word, idx) => {
		// 	const node = new cc.Node();
		// 	const label = node.addComponent(cc.Label);
		// 	label.string = word;
		// 	node.parent = layout;
		// 	node.color = colorList[idx];
		// 	cc.tween(node)
		// 		.delay(idx / 4)
		// 		.by(0.3, { y: 50 }, { easing: 'sineOut' })
		// 		.by(0.3, { y: -50 }, { easing: 'sineIn' })
		// 		.delay((str.length - idx) / 4)
		// 		.union()
		// 		.repeatForever()
		// 		.start();
		// });
		// const totalWidth = layout.children.reduce((width, node, idx) => {
		// 	return width + node.width;
		// }, 0);
		// layout.width = totalWidth;

	},

	hideWaitingLetters() {

		const layout = cc.find('middleLayer/layout');
		layout.active = false;

		const laodingLayer = cc.find('middleLayer/loadingLayer');
		laodingLayer.active = false;
	},

	showLog(str) {
		if (!this.logList) {
			this.logList = [];
		}
		this.logList.push(str);
		console.log(str);

		if (this.logList.length == 1) {
			this.showOneLog();
		}
	},

	showDebugUI() {
		cc.find('middleLayer/ConsoleNode/BtnOpen').active = true;
	},

	showOneLog() {
		const str = this.logList[0];
		if (str === undefined) {
			return;
		}
		const node = new cc.Node();
		node.anchorX = 0.5;
		const label = node.addComponent(cc.RichText);
		label.string = `<outline color=black width=3>${str}</outline>`;
		label.maxWidth = this.node.width / 2;
		node.x = this.node.width / 4;
		node.y = -this.node.height / 2;
		node.parent = this.node;
		cc.tween(node)
			.to(5, { y: this.node.height })
			.removeSelf()
			.start();
		setTimeout(() => {
			this.logList.shift();
			this.showOneLog();
		}, 1000);
	},

	exit() {
		cc.game.removePersistRootNode(this.node);
		cc.director.loadScene("emptyScene", () => {
			this.callNativeFunction({ name: 'exit', value: '' });
		});
	},

	getRainbowColorList() {
		return [
			cc.color(255, 255, 0),
			cc.color(128, 255, 0),
			cc.color(0, 255, 0),
			cc.color(0, 0, 0),

			cc.color(0, 255, 128),
			cc.color(0, 255, 255),

			cc.color(0, 128, 255),
			cc.color(0, 0, 255),
			cc.color(128, 0, 255),
			cc.color(255, 0, 255),
			cc.color(255, 0, 128),

			cc.color(255, 0, 0),
			cc.color(255, 128, 0),
			cc.color(255, 255, 0),
		];
	}
});
