export class middleLayerBase extends cc.Component {
	callNetworkApiPost(uri, data, callBack) {
		this.getBaseUrl((baseUrl) => {
			const xhr = new XMLHttpRequest();
			const url = `${baseUrl}${uri}`;
			xhr.open("POST", url, true);
			xhr.setRequestHeader('content-type', 'application/json');
			xhr.onreadystatechange = () => {
				if (xhr.readyState == 4) {
					callBack(JSON.parse(xhr.responseText));
				}
			}
			xhr.send(JSON.stringify(data));
		});
	}

	callNetworkApiGet(uri, data, callBack) {
		this.getBaseUrl((baseUrl) => {
			let queryStr = '?';
			const params = [];
			for (const key in data) {
				if (Object.hasOwnProperty.call(data, key)) {
					params.push(`${key}=${data[key]}`);
				}
			}
			queryStr += params.join("&");
			const xhr = new XMLHttpRequest();
			xhr.onreadystatechange = () => {
				if (xhr.readyState == 4 && (xhr.status >= 200 && xhr.status < 400)) {
					callBack(xhr.responseText);
				}
			};
			const url = `${baseUrl}${uri}${queryStr}`;
			console.log('url = ' + url);
			xhr.open('GET', url, true);
			xhr.send();
		});
	}

  async getBaseUrl(callback) {
    const engineInfo = await this.getEngineInfo();
    const { isDev } = JSON.parse(engineInfo);
    if (isDev == 1) {
      callback('http://staging-openapi.iteachabc.com');
    } else {
      callback('http://openapi.iteachabc.com');
    }
  }

  getEngineInfo() {
    if ((<any>window).air.engineInfo) {
      return (<any>window).air.engineInfo;
    } else {
      return new Promise((resolve, reject) => {
        (<any>window).courseware.getEngineInfo(() => {
          resolve((<any>window).air.engineInfo);
        });
      });
    }
  }
  asyncCallNetworkApiGet(apiName, data) {
    return new Promise((resolve, reject) => {
      this.callNetworkApiGet(apiName, data, (res => {
        resolve(res);
      }));
    });
  }
  asyncCallNetworkApiPost(uri, data) {
    return new Promise((resolve, reject) => {
      this.callNetworkApiPost(uri, data, (res) => {
        resolve(res);
      });
    });
  }
}