import { asyncDelay, saveLearning, asyncGetSpriteFrimeByUrl, playAudioByUrl } from "../script/util";
import { MyCocosSceneComponent } from "../script/MyCocosSceneComponent";

const { ccclass, property } = cc._decorator;

@ccclass
export default class SceneComponent extends MyCocosSceneComponent {

    addPreloadImage() {
    }

    addPreloadAudio() {
        for (let i = 0; i < this.data.length; i++) {
            const item = this.data[i];
            this._audioResList.push({ url: item.audio_url });
        }
    }

    addPreloadAnima() {

    }

    async onLoadEnd() {
        this.initData();
        await this.initView();
        this.initListener();
    }

    _cantouch = null;
    initData() {
        // 所有全局变量 默认都是null 
        this._cantouch = true;
    }


    currentCardData = null;
    async initView() {

        const cardview = cc.find(`Canvas/cardview`);
        const cardview_bg = cc.find(`Canvas/cardview_bg`);

        const content = cc.find(`Canvas/cardpage/view/content`);
        const item = cc.find(`item`, content);
        for (let i = 0; i < this.data.length; i++) {
            const d = this.data[i];
            const itemClone = cc.instantiate(item);
            itemClone.parent = content;
            itemClone.active = true;
            cc.find("word/text_en", itemClone).getComponent(cc.Label).string = d.text_en;

            itemClone.on('click', async () => {
                if (itemClone['cantClick']) {
                    return;
                }
                itemClone['cantClick'] = true;

                this.currentCardData = d;

                cc.find("word/cur/text_en", cardview).getComponent(cc.Label).string = d.text_en;
                cc.find("card/cur/text_cn", cardview).getComponent(cc.Label).string = d.text_cn;

                cardview_bg.active = true;
                cardview.active = true;

                cc.tween(cardview).to(0.1, {rotation: 5}).to(0.2, {rotation: -5}).to(0.1, {rotation: 0})
                .call(() => {
                    itemClone['cantClick'] = false;
                }).start()

            });

        }
    }

    initListener() {
        const cardview = cc.find(`Canvas/cardview`);
        cardview.on('click', () => {
            cc.audioEngine.stopAll();
            playAudioByUrl(this.currentCardData.audio_url);
            cc.tween(cardview).to(0.1, {rotation: 5}).to(0.2, {rotation: -5}).to(0.1, {rotation: 0}).start();

            // 点击就算学过
            saveLearning(this.currentCardData);
        });

        const cardview_bg = cc.find(`Canvas/cardview_bg`);
        cardview_bg.on('click', () => {
            cardview_bg.active = false;
            cardview.active = false;
            cc.audioEngine.stopAll();
            cc.find(`card`, cardview).active = false;
            cc.find(`word`, cardview).active = true;
        });

        const turn = cc.find(`Canvas/cardview/turn`);
        turn.on('click', () => {
            const cardActive = cc.find(`card`, cardview).active;
            const wordActive = cc.find(`word`, cardview).active;
            cc.find(`card`, cardview).active = wordActive;
            cc.find(`word`, cardview).active = cardActive;
        });
    }
}
