
import { initAir } from './air';
import { playAudio, showBigStar } from './util';
cc.Class({
	extends: cc.Component,
	properties: {
	},

	callNetworkApiPost(baseUrl, uri, data, callBack) {
		const xhr = new XMLHttpRequest();
		const url = `${baseUrl}${uri}`;
		xhr.open("POST", url, true);
		xhr.setRequestHeader('content-type', 'application/json');
		xhr.onreadystatechange = () => {
			if (xhr.readyState == 4) {
				callBack(JSON.parse(xhr.responseText));
			}
		}
		xhr.send(JSON.stringify(data));
	},

	callNetworkApiGet(baseUrl, uri, data, callBack) {
		let queryStr = '?';
		const params = [];
		for (const key in data) {
			if (Object.hasOwnProperty.call(data, key)) {
				params.push(`${key}=${data[key]}`);
			}
		}
		queryStr += params.join("&");
		const xhr = new XMLHttpRequest();
		xhr.onreadystatechange = () => {
			if (xhr.readyState == 4 && (xhr.status >= 200 && xhr.status < 400)) {
				callBack(JSON.parse(xhr.responseText));
			}
		};
		const url = `${baseUrl}${uri}${queryStr}`;
		console.log('url = ' + url);
		xhr.open('GET', url, true);
		xhr.send();
	},

	callNetworkApiGetLocal(baseUrl, uri, data, callBack) {
		let queryStr = '?';
		const params = [];
		for (const key in data) {
			if (Object.hasOwnProperty.call(data, key)) {
				params.push(`${key}=${data[key]}`);
			}
		}
		queryStr += params.join("&");
		const xhr = new XMLHttpRequest();
		xhr.onreadystatechange = () => {
			if (xhr.readyState == 4 && (xhr.status >= 200 && xhr.status < 400)) {
				callBack(xhr.responseText);
			}
		};
		const url = `${baseUrl}${uri}${queryStr}`;
		console.log('url = ' + url);
		xhr.open('GET', url, true);
		xhr.send();
	},

	// 需要预加载的数量
	preloadCount: null,
	// 统计已加载的数量
	loadedCount: null,

	baseApiUrl: null, // API地址
	engineCode: null, // 机器唯一编码
	userCode: null, // 用户唯一编码
	name: null, // 用户取的英文名
	birthday: null, // 用户的生日
	courseIds: null, // 根据推荐生成的课件ID数组
	currentIndex: null, // 当前进行的是courseIds里第几个课件

	// 统一释放异步资源的方法
	onLoad() {
		this.preloadCount = 0;
		this.loadedCount = 0;
		initAir(this);
		this.initAudio();
	},

	start() {
		this.turnPageWait = 0;
		this.node.zIndex = 9999;
		cc.game.addPersistRootNode(this.node);
		this.initListener();
		this.initPageInfo();
		this.hideUI();
		this.showWaitingLetters();
		this.initTerminalInfo(() => {
			this.getUserStar(); // 获取用户所获得的星星数量
			this.getUserQrcode(); // 获取用户动态小程序码
			this.loadGame();
		});
	},

	initAudio() {
		this.bigStarClip = cc.find('middleLayer/res/audio/big_star').getComponent(cc.AudioSource).clip;
	},

	initTerminalInfo(callback) {
		window.courseware.getEngineInfo(res => {
			const { isDev, uuid } = JSON.parse(res);
			if (isDev) {
				// 这里后面给个测试环境地址
				this.baseApiUrl = `https://api.iplayabc.com/`;
			} else {
				this.baseApiUrl = `https://api.iplayabc.com/`;
			}
			this.engineCode = uuid;
			this.getUserCode(callback); // 获取用户基本信息
		});
	},

	getUserCode(callback) {
		this.callNetworkApiPost(this.baseApiUrl, "v1/terminal/store", {
			engine_code: this.engineCode,
			name: 'default_name',
			birthday: '20200202'
		}, res => {
			if (res.code === 200) {
				this.userCode = res.data.user_code;
				this.name = res.data.name;
				this.birthday = res.data.birthday;
				callback && callback();
			}else{
				console.log("-----error------");
				console.log(res.msg);
				// TODO 提示错误和上报错误
			}
		});
	},

	getUserQrcode() {
		cc.assetManager.loadRemote(`${this.baseApiUrl}v1/wechart/wxacode?user_code=${this.userCode}`,{ext: '.jpeg'}, (err, img) => {
			if(err) {
				console.log("==远程图片加载错误==");
				// TODO 上报错误
			} else {
				const spriteFrame = new cc.SpriteFrame(img);
				cc.find('middleLayer/qrcode').getComponent(cc.Sprite).spriteFrame = spriteFrame;
			}
		})
	},

	getUserStar() {
		this.callNetworkApiGet(this.baseApiUrl, "v1/terminal/user/stars", {
			user_code: this.userCode,
		}, res => {
			if (res.code === 200) {
				// const starLabel = cc.find('middleLayer/star_count_label').getComponent(cc.Label);
				const starLabel = cc.find('middleLayer/star_node/star_count_label').getComponent(cc.RichText);
				starLabel.string = `<outline color=black width=2><b>${res.data} </b></outline>` ;
			}else{
				console.log("-----error------");
				console.log(res.msg);
				// TODO 提示错误和上报错误
			}
		});

	},

	initPageInfo() {
		const addressText = cc.find('middleLayer/ui/address');
		const str = cc.sys.localStorage.getItem('ip');
		console.log('str = ' + str);
		if (str) {
			addressText.getComponent(cc.EditBox).string = str;
		}

		const nameText = cc.find('middleLayer/ui/bundleName');
		const bundleName = cc.sys.localStorage.getItem('bundleName');
		if (bundleName) {
			nameText.getComponent(cc.EditBox).string = bundleName;
		}

		const courseIdNode = cc.find('middleLayer/ui/courseId');
		const courseId = cc.sys.localStorage.getItem('courseId');
		if (courseId) {
			courseIdNode.getComponent(cc.EditBox).string = courseId;
		}

		global.middleLayer = cc.find('middleLayer').getComponent('middleLayer');
		middleLayer.log("middleLayer.log('像这样在这里打log')");
	},

	getHistoryLastCourse(callback) {
		this.callNetworkApiGet(this.baseApiUrl, `v1/terminal/user/answers/1`, { user_code: this.userCode }, res => {
			callback(res.data.rows[0]);
		});
	},

	loadGame() {
		this.callNetworkApiGet(this.baseApiUrl, `v1/preference/courseware`, { user_code: this.userCode }, res => {
			if (res.code !== 200) {
				console.log("-----error------");
				console.log(res.msg);
				// TODO 提示错误和上报错误
				return;
			}
			this.courseIds = res.data;
			this.getHistoryLastCourse(item => {
				this.currentIndex = item?this.courseIds.indexOf(item.syllabus_id):0;
				this.loadOnlineCourseWare(this.courseIds[this.currentIndex], false);
			});
		});
	},

	addStar(count, animationFlag) {
		
		if(animationFlag){
			// TODO 添加星星的动画
			
			for (let i=0; i<count; i++) {

				setTimeout(() => {

					let star = cc.find('middleLayer/star_node/icon_star');
					const resItem = cc.find('middleLayer/res/icon_bigstar');
					const starBig = cc.instantiate(resItem);
					starBig.parent = star.parent;

					showBigStar(starBig, star);
				}, i * 500);
				
				
			}
			playAudio(this.bigStarClip);
		

		}

		this.callNetworkApiPost(this.baseApiUrl, `v1/terminal/star/save`, {
			syllabus_id: this.courseItem.course_id,
			courseware_id: this.courseItem.id,
			engine_code: this.engineCode,
			template_name: this.courseItem.template_name,
			stars: count,
		})
	},
	
	preloadAll() {
		if (window.preloadBundleAndSourcesFlag) {
			// 只加载一次就行了
			return;
		}
		window.preloadBundleAndSourcesFlag = true;
		cc.find("middleLayer/ui/ProgressLabel").active = true;
		cc.find('middleLayer/ui/loadingProgress').active = true;
		let platform = "web_desktop";
		if (cc.sys.os == cc.sys.OS_IOS) {
			platform = "ios";
		} else if (cc.sys.os == cc.sys.OS_ANDROID) {
			platform = "android";
		}
		this.callNetworkApiGet(`http://staging-teach.ireadabc.com`, `/api/syllabus/v1/allbundles`, { orgid: 488, platform }, (data) => {
			if (data.rows && data.rows.length > 0) {
				this.preloadCount += data.rows.length;
			}
			this.callNetworkApiGet(`http://staging-teach.ireadabc.com`, `/api/syllabus/v1/allresources`, { orgid: 488 }, (data1) => {
				if (data1.rows && data1.rows.length > 0) {
					this.preloadCount += data1.rows.length;
				}
				console.log('data.rows = ' + JSON.stringify(data.rows));
				this.batchPreloadScene(data.rows);
				this.preloadSource(data1.rows);
			});
		});
	},

	preloadSourceImman() {
		// 测试用
		cc.find("middleLayer/ui/ProgressLabel").active = true;
		cc.find('middleLayer/ui/loadingProgress').active = true;
		this.callNetworkApiGet(`http://staging-teach.ireadabc.com`, `/api/courseware/v1/getresources`, { courseid: 20894 }, (data1) => {
			if (data1.rows && data1.rows.length > 0) {
				this.preloadCount += data1.rows.length;
			}
			this.log('data1.rows = ' + JSON.stringify(data1.rows));
			this.preloadSource(data1.rows);
		});
	},

	batchPreloadScene(scenes = []) {
		const expects = [
			// 'op_03_2',  
			// 'OP10_online', 
		];
		const _this = this;
		let i = 0;
		const load = function () {
			const scene = scenes[i];
			if (expects.includes(scene.sceneName)) {
				_this.loadedCount++;
				_this.updateProcessBar();
				i++;
				if (i < scenes.length) {
					setTimeout(() => {
						load();
					}, 1);
				}
				return;
			}
			cc.assetManager.loadBundle(scene.bondleUrl, { version: scene.version }, (err, bundle) => {
				console.log(`${scene.bondleUrl}---场景开始loadBundle----`);
				if (!bundle) {
					_this.loadedCount++;
					_this.updateProcessBar();
					i++;
					if (i < scenes.length) {
						setTimeout(() => {
							load();
						}, 1);
					}
					return;
				}
				bundle.preloadScene(scene.sceneName, () => { }, () => {
					console.log(`${scene.sceneName}场景预加载结束`);
					_this.loadedCount++;
					_this.updateProcessBar();
					i++;
					if (i < scenes.length) {
						setTimeout(() => {
							load();
						}, 1);
					}
				});
			});
		}

		if (scenes && scenes.length > 0) {
			load();
		}
	},

	preloadSource(array) {
		const rows = array || [];
		const batchLoad = () => {
			let tempArr = rows.splice(0, 10);
			let len = tempArr.length;
			for (let i = 0; i < tempArr.length; i++) {
				cc.assetManager.loadRemote(tempArr[i], (err, texture) => {
					if (err) {
						console.log(err)
					}
					this.loadedCount++;
					this.updateProcessBar();
					if (i === len - 1) {
						batchLoad();
					}
				});
			}
		}
		batchLoad();
	},

	updateProcessBar() {
		const label = cc.find("middleLayer/ui/ProgressLabel").getComponent(cc.Label);
		const loadingProgress = cc.find('middleLayer/ui/loadingProgress');
		label.string = `正在加载：${this.loadedCount} / ${this.preloadCount}`;
		if (this.loadedCount > this.preloadCount * 0.99) {
			cc.find("middleLayer/ui/ProgressLabel").active = false;
			loadingProgress.active = false;
			this.showLog("资源全部加载完成");
		}
		loadingProgress.getComponent(cc.ProgressBar).progress = this.loadedCount / this.preloadCount;
	},

	asyncDelayLog(str) {
		console.log(str);
		return new Promise((resolve, reject) => {
			setTimeout(() => {
				resolve();
			}, 1);
		});
	},

	initListener() {

		cc.find('middleLayer/qrcode_bg').on('click', () => {
			cc.find('middleLayer/qrcode').active = false;
			cc.find('middleLayer/qrcode_bg').active = false;
		});
		cc.find('middleLayer/BtnShowQrcode').on('click', () => {
			cc.find('middleLayer/qrcode').active = true;
			cc.find('middleLayer/qrcode_bg').active = true;
		});

		cc.find('middleLayer/ExitBtn').on('click', () => {
			cc.find('middleLayer/BtnRight').active = false;
			cc.find('middleLayer/BtnLeft').active = false;

			cc.tween(exitBtn)
				.to(0.1, { scaleX: 0.4, scaleY: 0.6 })
				.to(0.1, { scaleX: 0.6, scaleY: 0.4 })
				.to(0.1, { scaleX: 0.5, scaleY: 0.5 })
				.call(() => {
					exitBtn.active = false;
					cc.game.removePersistRootNode(this.node);
					cc.director.getScene().destroy();
					cc.audioEngine.stopAll();
					window.courseware.freeAllOcMethod();
					cc.director.loadScene("debug_shell", null, null, (err, scene) => {

					});
				})
				.start();
		});
		cc.find('middleLayer/BtnRight').on('click', () => {
			this.goNextPage();
		});
		cc.find('middleLayer/BtnLeft').on('click', () => {
			this.goPrePage();
		});
		cc.find('middleLayer/ui/BtnOpenOsmo').on('click', () => {
			window.courseware.openOsmo();
		});
		cc.find('middleLayer/ui/BtnCloseOsmo').on('click', () => {
			window.courseware.closeOsmo();
		});
		cc.find('middleLayer/ui/BtnOpenRecord').on('click', () => {
			window.courseware.startRecord('');
		});
		cc.find('middleLayer/ui/BtnCloseRecord').on('click', () => {
			window.courseware.stopRecord(0, res => {
				this.log('--------录音返回结果 stopRecord ------------');
				this.log(JSON.stringify(res))
				this.log('------------------------------');
			});
		});
		cc.find('middleLayer/ui/BtnOpenTest').on('click', () => {
			window.courseware.startTest('');
		});
		cc.find('middleLayer/ui/BtnCloseTest').on('click', () => {
			window.courseware.stopTest(res => {
				this.log('--------录音评测返回结果 stopTest ---------');
				this.log(JSON.stringify(res))
				this.log('------------------------------');
			});
		});

		const BtnStartLocal = cc.find('middleLayer/ui/BtnStartLocal');
		BtnStartLocal.on('click', () => {
			const addressText = cc.find('middleLayer/ui/address');
			const str = addressText.getComponent(cc.EditBox).string;
			cc.sys.localStorage.setItem('ip', str);
			const address = str.split(':')[0];
			const port = str.split(':')[0] | 8081;
			this.localMode = true;
			this.loadLocalBundle(address, port);
			this.showWaitingLetters();
			this.hideUI();
			this.showDebugUI();
		});

		const BtnStartOnline = cc.find('middleLayer/ui/BtnStartOnline');
		BtnStartOnline.on('click', () => {
			const nameText = cc.find('middleLayer/ui/bundleName');
			const bundleName = nameText.getComponent(cc.EditBox).string;
			cc.sys.localStorage.setItem('bundleName', bundleName);
			this.loadOnlineBundle(bundleName);
			this.showDebugUI();
		});

		const BtnStartCourseWare = cc.find('middleLayer/ui/BtnStartCourseWare');
		BtnStartCourseWare.on('click', () => {
			const courseIdNode = cc.find('middleLayer/ui/courseId');
			const courseId = courseIdNode.getComponent(cc.EditBox).string;
			cc.sys.localStorage.setItem('courseId', courseId);
			this.loadOnlineCourseWare(courseId);
			this.showDebugUI();
		});

		const BtnLoad = cc.find('middleLayer/ui/BtnLoad');
		BtnLoad.on('click', () => {
			this.preloadCount = 0;
			this.loadedCount = 0;
			cc.find("middleLayer/ui/ProgressLabel").active = true;
			cc.find('middleLayer/ui/loadingProgress').active = true;
			// this.preloadAll();
			this.preloadSourceImman();
		});

		const btnClose = cc.find('middleLayer/ConsoleNode/BtnClose');
		const btnOpen = cc.find('middleLayer/ConsoleNode/BtnOpen');
		const consoleNode = cc.find('middleLayer/ConsoleNode/Console');
		const consoleBg = cc.find('middleLayer/ConsoleNode/bg');
		btnOpen.on('click', () => {
			btnClose.active = true;
			btnOpen.active = false;
			consoleNode.active = true;
			consoleBg.active = true;
		});

		btnClose.on('click', () => {
			btnClose.active = false;
			btnOpen.active = true;
			consoleNode.active = false;
			consoleBg.active = false;
		});
	},

	goNextCourseware() {
		this.currentIndex ++;
		if(!this.courseIds[this.currentIndex]){
			this.currentIndex = 0;
		}
		this.callNetworkApiGet(`http://iteachabc.com`, `/api/courseware/v1/${this.courseIds[this.currentIndex]}/list`, {}, (data) => {
			if (data.rows && data.rows.length > 0) {
				this.courses = data.rows;
				this.courseIndex = 0;
				this.courseItem = data.rows[0];
				this.loadPageBundle();
			} else {
				// 没有制作课件页，直接切换到下一个课件
				this.goNextCourseware();
			}
		});
	},

	goPrePage() {
		this.goTarIndexPage(this.courseIndex - 1);
	},
	goNextPage() {
		this.goTarIndexPage(this.courseIndex + 1);
	},
	goTarIndexPage(index) {
		if (!this.courses || index == this.courseIndex || index < 0 ) {
			return;
		}
		this.showMask();
		this.showWaitingLetters();
		window.courseware.freeAllOcMethod();

		if (index > this.courses.length - 1) {
			// 本课件播放完了，切换到下一个课件
			this.goNextCourseware();
			return;
		}
		this.courseIndex = index;
		this.courseItem = this.courses[this.courseIndex];
		this.loadPageBundle();
	},
	log(str) {
		const logStr = `${new Date().toLocaleString()}: ${str}`;
		console.log(logStr);
		const content = cc.instantiate(cc.find('middleLayer/ConsoleNode/content'));
		content.active = true;
		const label = content.getChildByName('label');
		label.getComponent(cc.Label).string = logStr;
		const consoleContent = cc.find('middleLayer/ConsoleNode/Console/content');
		consoleContent.addChild(content);
		consoleContent.getComponent(cc.Layout).updateLayout();
	},
	hideUI() {
		cc.find('middleLayer/ui').active = false;
	},
	loadOnlineBundle(bundleName) {
		this.showWaitingLetters();
		this.callNetworkApiGet(`http://staging-teach.ireadabc.com`, `/api/template/v1/${bundleName}`, {}, (data) => {
			let configData = null;
			if (cc.sys.os == cc.sys.OS_IOS) {
				configData = data.data.conf.ios;
			} else if (cc.sys.os == cc.sys.OS_ANDROID) {
				configData = data.data.conf.android;
			} else {
				configData = data.data.conf.web_desktop;
			}
			const sceneName = configData.sceneName;
			const version = configData.version;
			const bondleUrl = configData.bondleUrl;
			this.loadBundle(sceneName, version, bondleUrl);
		});
	},
	courses: null,
	courseIndex: 0,
	courseItem: null,
	loadOnlineCourseWare(courseId, linkFlag) {
		this.hideUI();
		this.showMask();
		this.showWaitingLetters();

		let api = `/api/courseware/v1/${courseId}/list`;
		if (linkFlag === true) {
			api = `/api/courseware/v1/${courseId}/eq/level/list`;
		}
		this.callNetworkApiGet(`http://iteachabc.com`, api, {}, (data) => {
			if (data.rows && data.rows.length > 0) {
				this.courses = data.rows;
				this.courseIndex = data.index || 0;
				this.courseItem = data.rows[this.courseIndex];
			}
			if (this.courses && this.courses.length > 1 && this.courseIndex <= this.courses.length - 1) {
				// cc.find('middleLayer/BtnRight').active = true;
			}
			if (this.courseIndex > 0) {
				cc.find('middleLayer/BtnLeft').active = false;
			}
			this.reWriteAir();
			this.loadPageBundle();
		});
	},
	loadLocalBundle(address, port) {
		this.callNetworkApiGetLocal(`http://${address}:${port}`, '/dist/config.json', {}, (datastr) => {
			const data = JSON.parse(datastr);
			let sceneName = '';
			let version = '';
			let bondleUrl = '';
			if (cc.sys.os == cc.sys.OS_IOS) {
				sceneName = data.ios.sceneName;
				version = data.ios.version;
				bondleUrl = `http://${address}:${port}/dist/ios/${sceneName}/`;
			} else if (cc.sys.os == cc.sys.OS_ANDROID) {
				sceneName = data.android.sceneName;
				version = data.android.version;
				bondleUrl = `http://${address}:${port}/dist/android/${sceneName}/`;
			} else {
				sceneName = data.android.sceneName;
				version = "";
				bondleUrl = `http://${address}:${port}/dist/web_desktop/`;
			}
			this.loadBundle(sceneName, version, bondleUrl);
		});
	},
	loadPageBundle() {
		let sceneName, version, bondleUrl = "";
		if (cc.sys.os == cc.sys.OS_IOS) {
			sceneName = this.courseItem.conf.ios.sceneName;
			version = this.courseItem.conf.ios.version;
			bondleUrl = this.courseItem.conf.ios.bondleUrl;
		} else if (cc.sys.os == cc.sys.OS_ANDROID) {
			sceneName = this.courseItem.conf.android.sceneName;
			version = this.courseItem.conf.android.version;
			bondleUrl = this.courseItem.conf.android.bondleUrl;
		} else {
			sceneName = this.courseItem.conf.web_desktop.sceneName;
			version = this.courseItem.conf.web_desktop.version;
			bondleUrl = this.courseItem.conf.web_desktop.bondleUrl;
		}

		this.loadBundle(sceneName, version, bondleUrl);
	},
	loadBundle(sceneName, version, bondleUrl) {
		this.currentBundleInfo = { sceneName, version, bondleUrl };
		cc.assetManager.loadBundle(bondleUrl, { version: version }, async (err, bundle) => {
			if (err) {
				return this.asyncDelayLog(err);
			}
			bundle.loadScene(sceneName, null, null, (err, scene) => {
				if (err) {
					this.asyncDelayLog('err: ', err);
				}
				cc.audioEngine.stopAll();
				cc.director.runScene(scene, null, () => {
					console.log('sceneName = ' + sceneName);
					const Canvas = cc.find('Canvas');
					const middleLayer = cc.find('middleLayer');
					// cc.find('middleLayer/ExitBtn').active = true;
					this.hideMask();
					this.hideWaitingLetters();
					Canvas.getComponent(cc.Widget).updateAlignment();
					middleLayer.scale = Canvas.width / middleLayer.width;
					// this.showLog('middleLayer.scale = ' + middleLayer.scale);
				});
			});
		});
	},

	showMask() {
		const mask = cc.find('middleLayer/mask');
		mask.active = true;
		cc.tween(mask)
			.set({ opacity: 0 })
			.to(0.2, { opacity: 180 })
			.start();
	},

	hideMask() {
		const mask = cc.find('middleLayer/mask');
		mask.stopAllActions();
		cc.tween(mask)
			.set({ opacity: 180 })
			.to(0.2, { opacity: 0 })
			.call(() => {
				mask.active = false;
			})
			.start();
	},

	turnPageWait: 0,
	reWriteAir() {
		window.courseware.getData = (callback) => {
			let data = null;
			if (this.courseItem.data) {
				data = JSON.parse(this.courseItem.data);
			}
			this.log("===成功调用getData===" + this.courseItem.data);
			callback && callback(data);
		}
		window.courseware.nextPage = () => {
			setTimeout(() => {
				this.goNextPage();
			}, this.turnPageWait);
			this.turnPageWait = 0;
		}
		window.courseware.beforePage = () => {
			this.goPrePage();
		}
		window.courseware.sendAnswer = (answerObj) => {
			this.log("===成功调用sendAnswer===" + JSON.stringify(answerObj));
			this.turnPageWait = 2000;
			this.addStar(3, true); // 上报成绩则获得三颗星星并展示动画
			this.callNetworkApiPost(this.baseApiUrl, `v1/terminal/save/answer`, {
				syllabus_id: this.courseItem.course_id,
				courseware_id: this.courseItem.id,
				engine_code: this.engineCode,
				name: this.name,
				template_name: this.courseItem.template_name,
				template_description: this.courseItem.template_description,
				result: JSON.stringify(answerObj),
			}, (data) => {
				answerObj.callback && answerObj.callback(JSON.stringify(data.data));
			});
		}
		window.courseware.addStar = this.addStar.bind(this);
	},

	callNativeFunction(param) {
		const paramStr = JSON.stringify(param);
		if (cc.sys.isNative && cc.sys.os == cc.sys.OS_IOS) {
			return jsb.reflection.callStaticMethod('CocosMng', 'cocosWithNativeProtocol:', paramStr);
		} else if (cc.sys.isNative && cc.sys.os == cc.sys.OS_ANDROID) {
			return jsb.reflection.callStaticMethod('com/iplayabc/cocos/AppActivity', 'cocosWithNativeProtocol', '(Ljava/lang/String;)Ljava/lang/String;', paramStr);
		} else if (cc.sys.isNative && cc.sys.os == cc.sys.OS_WINDOWS) {
			console.log('汪汪汪')
		} else {
			console.error('非源生环境');
		}
	},



	showWaitingLetters() {

		if (this.isShowWaiting) {
			return;
		}
		this.isShowWaiting = true;

		const colorList = this.getRainbowColorList();
		const layout = cc.find('middleLayer/layout');
		layout.removeAllChildren();
		layout.active = true;
		const str = 'Now Loading...';
		str.split('').forEach((word, idx) => {
			const node = new cc.Node();
			const label = node.addComponent(cc.Label);
			label.string = word;
			node.parent = layout;
			node.color = colorList[idx];
			cc.tween(node)
				.delay(idx / 4)
				.by(0.3, { y: 50 }, { easing: 'sineOut' })
				.by(0.3, { y: -50 }, { easing: 'sineIn' })
				.delay((str.length - idx) / 4)
				.union()
				.repeatForever()
				.start();
		});
		const totalWidth = layout.children.reduce((width, node, idx) => {
			return width + node.width;
		}, 0);
		layout.width = totalWidth;
		
	},

	hideWaitingLetters() {
		const layout = cc.find('middleLayer/layout');
		layout.active = false;
		this.isShowWaiting = false;
	},

	showLog(str) {
		if (!this.logList) {
			this.logList = [];
		}
		this.logList.push(str);
		console.log(str);

		if (this.logList.length == 1) {
			this.showOneLog();
		}
	},

	showDebugUI() {
		cc.find('middleLayer/ConsoleNode/BtnOpen').active = true;
	},

	showOneLog() {
		const str = this.logList[0];
		if (str === undefined) {
			return;
		}
		const node = new cc.Node();
		node.anchorX = 0.5;
		const label = node.addComponent(cc.RichText);
		label.string = `<outline color=black width=3>${str}</outline>`;
		label.maxWidth = this.node.width / 2;
		node.x = this.node.width / 4;
		node.y = -this.node.height / 2;
		node.parent = this.node;
		cc.tween(node)
			.to(5, { y: this.node.height })
			.removeSelf()
			.start();
		setTimeout(() => {
			this.logList.shift();
			this.showOneLog();
		}, 1000);
	},
	
	exit() {
		cc.game.removePersistRootNode(this.node);
		cc.director.loadScene("emptyScene", () => {
				this.callNativeFunction({ name: 'exit', value: '' });
		});  
},

	getRainbowColorList() {
		return [
			cc.color(255, 255, 0),
			cc.color(128, 255, 0),
			cc.color(0, 255, 0),
			cc.color(0, 0, 0),

			cc.color(0, 255, 128),
			cc.color(0, 255, 255),

			cc.color(0, 128, 255),
			cc.color(0, 0, 255),
			cc.color(128, 0, 255),
			cc.color(255, 0, 255),
			cc.color(255, 0, 128),

			cc.color(255, 0, 0),
			cc.color(255, 128, 0),
			cc.color(255, 255, 0),
		];
	}
});
