import { Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef } from '@angular/core';
import { JsonPipe } from '@angular/common';
import { ComponentBase } from './ComponentBase';


@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent extends ComponentBase implements OnInit, OnChanges, OnDestroy {

  // 储存数据用
  saveKey = "card_machine";
  // 储存对象
  item: any = {
    title: '',
    questionText: '',
    questionTextAudio: '',
    questions: [],
  };

  addQuestion() {
    this.item.questions.push({
      type: 'img',
      audio: '',
      text: '',
      image: ''
    });
    this.save();
  }

  removeQuestion(idx) {
    this.item.questions.splice(idx, 1);
    this.save();
  }
}