const { removeDir, copyDir } = require('./utils');
let fs = require('fs');

async function main() {
  await removeDir('../dist/play');

  await copyDir('../play/build/web-desktop', '../dist/play');
  const data = await fs.readFileSync('../play/index.html');
  await fs.writeFileSync('../dist/play/index.html', data);

  await removeDir('../play/build/web-desktop');


  const path = '../play/assets'
  let folderName = '';
  fs.readdirSync(path).find(fileName => {
    const st = fs.statSync(`${path}/${fileName}`);
    if (st.isDirectory()) {
      folderName = fileName;
    }
  });
  const metaPath = `${path}/${folderName}.meta`;
  const metaDataStr = fs.readFileSync(metaPath);
  const metaData = JSON.parse(metaDataStr);
  metaData.isBundle = true;
  metaData.isRemoteBundle = {
    ios: true,
    android: true
  };
  fs.writeFileSync(metaPath, JSON.stringify(metaData));
}

main();