// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

import pg from "./tool/pg";

const { ccclass, property } = cc._decorator;

@ccclass
export default class Box2d extends cc.Component {
    // LIFE-CYCLE CALLBACKS:
    private layout_item: cc.Node;
    onLoad() {
        cc.director.getPhysicsManager().enabled = true;

        // cc.director.getPhysicsManager().debugDrawFlags = cc.PhysicsManager.DrawBits.e_jointBit | cc.PhysicsManager.DrawBits.e_shapeBit;
        cc.director.getPhysicsManager().debugDrawFlags = 0;
        cc.director.getPhysicsManager().gravity = cc.v2(0, -640);

        // 开启物理步长的设置
        var manager = cc.director.getPhysicsManager();
        manager.enabledAccumulator = true;
        // 物理步长，默认 FIXED_TIME_STEP 是 1/60
        cc.PhysicsManager.FIXED_TIME_STEP = 1 / 30;
        // 每次更新物理系统处理速度的迭代次数，默认为 10
        cc.PhysicsManager.VELOCITY_ITERATIONS = 8;
        // 每次更新物理系统处理位置的迭代次数，默认为 10
        cc.PhysicsManager.POSITION_ITERATIONS = 8;

        this.layout_item = this.node.getChildByName('layout_item')

        pg.event.on("box2d_init", (len: number) => {
            let arr = [];
            for (let i = 0; i < len; i++) {
                arr.push(100 + i);
            }
            this.initOrange(arr);
        })
        pg.event.on("box2d_next", () => {
            this.jumpOrange();
        })
        pg.event.on("box2d_roll", () => {
            this.jumpRoll();
        })
        pg.event.on("box2d_hide", () => {
            this.hideJump();
        })
    }

    current: number;
    ids: Array<number>;
    jumpedNodes: Array<cc.Node>;
    initOrange(ids = [101, 102, 103, 104, 105]) {
        this.current = 0;
        this.jumpedNodes = [];
        this.ids = ids.concat();
        this.layout_item.removeAllChildren();
        let item = this.node.getChildByName("item");
        let p0 = cc.v2(-320, 305);
        let pSpace = cc.v2(120, 0)
        for (let i = 0; i < ids.length; i++) {
            let node = cc.instantiate(item);
            node.active = true;
            node.data = ids[i];
            this.layout_item.addChild(node);
            node.x = p0.x + pSpace.x * i;
            node.y = p0.y;
        }
    }
    findItemByIds(ids): Array<cc.Node> {
        return this.layout_item.children.filter(node => ids.some(id => id == node.data))
    }
    jumpOrange() {
        let baffle = this.node.getChildByName('baffle')
        baffle.active = false;
        let lid = this.node.getChildByName('lid')
        lid.active = false;
        // 根据current来找橘子及后续的内容
        let ids = this.ids.concat();
        let jumping: any = [ids[this.current++]];
        let moveing: any = []
        for (let i = this.current; i < ids.length; i++) {
            moveing.push(ids[i]);
        }
        jumping = this.findItemByIds(jumping)
        moveing = this.findItemByIds(moveing)
        jumping.forEach(node => {
            node.getComponent(cc.RigidBody).linearVelocity = cc.v2(-200, 0)
            this.jumpedNodes.push(node);
        })
        moveing.forEach(node => {
            node.getComponent(cc.RigidBody).linearVelocity = cc.v2(-100, 0)
            this.scheduleOnce(() => {
                baffle.active = true;
                node.getComponent(cc.RigidBody).linearDamping = 2
            }, 1.3)
        })
        setTimeout(() => {
            pg.event.emit("box2d_next_successed")
        }, 2000);
    }
    jumpRoll() {
        let lid = this.node.getChildByName('lid')
        lid.active = true;
        let list = this.jumpedNodes;
        list.forEach(node => {
            node.getComponent(cc.RigidBody).linearVelocity = cc.v2(370, 500)
        })
        setTimeout(() => {
            list.forEach(node => {
                node.getComponent(cc.RigidBody).linearVelocity = cc.v2(-370, 500)
            })
        }, 1000);
        setTimeout(() => {
            list.forEach(node => {
                node.getComponent(cc.RigidBody).linearVelocity = cc.v2(370, 500)
            })
        }, 2000);
        setTimeout(() => {
            list.forEach(node => {
                node.getComponent(cc.RigidBody).linearVelocity = cc.v2(-370, 500)
            })
            setTimeout(() => {
                pg.event.emit("box2d_roll_successed")
            }, 1000);
        }, 3000);
    }
    hideJump() {
        this.jumpedNodes.forEach(node => node.active = false)
    }
    start() {

    }

    // update (dt) {}
}
