import { Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef } from '@angular/core';
import { JsonPipe } from '@angular/common';
import { ComponentBase } from './ComponentBase';


@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent extends ComponentBase implements OnInit, OnChanges, OnDestroy {

  // 储存数据用
  saveKey = "ngt10_tydh";
  // 储存对象
  item: any = {
    imgAni: {
      ske: {},
      tex: {},
      png: {}
    },
    tipSwitch: 1,//提示功能开关
    startAudio: "",
    audioName: "",
    errorAudio: '',
    errorAudioName: "",
    title: "听音对话",
    //1 ~ 6 个
    questions: [],
  };
  // item: any = {
  //   title: '幸运大转盘',
  //   questionText: "亲爱的小玩家，游戏马上就要开始啦！请动动手指转动转盘，当转盘停止，注意观察指针指向的魔法图片，并大声说出魔法咒语，魔法咒语正确，你就可以获得一张魔法卡牌。 游戏结束后，根据获得的魔法卡牌数量，你将获得相应的能量石奖励！开始挑战吧！",
  //   questionTextAudio: "http://staging-teach.cdn.ireadabc.com/18ebee93b3eabcd55649a01366431af7.mp3",
  //   questions: [],
  // };

  isVisible = false;
  deleteTitle = "是否删除题目";
  deleteCallback = function () { };
  openDelete(title, callback) {
    this.deleteCallback = callback;
    this.deleteTitle = title;
    this.isVisible = true;
  }
  handleCancel() {
    this.isVisible = false;
  }
  handleOk() {
    this.deleteCallback && this.deleteCallback();
    this.handleCancel();
  }

  addQuestion() {
    // if (this.item.questions.length == 6) return;
    this.item.questions.push({
      type: 'txt',
      audio: '',
      text: '',
      image: '',
      time: null,
      audioName: "",
      word: '',
      noWord: 1
    });
    this.save();
  }

  removeQuestion(idx) {
    this.openDelete("确定删除题目？", () => {
      this.item.questions.splice(idx, 1);
      this.save();
    })
  }
  copyQuestion(idx) {
    let data = this.item.questions[idx]
    this.item.questions.push(JSON.parse(JSON.stringify(data)));
    this.save();
  }

  addOption(idx) {
    if (this.item.questions[idx].options.length == 4) return;
    this.item.questions[idx].options.push({
      text: '',
      audio: '',
      image: '',
      word: '',
      time: '',
    });
    this.save();
  }

  removeOption(idx, n) {
    this.openDelete("确定删除选项？", () => {
      this.item.questions[idx].options.splice(n, 1);
      this.save();
    })
  }

  onDragonBoneSave(e, item) {
    console.log(e);
    this.save();
  }
  ngChange() {
    this.save();
  }
}