import { Component, OnDestroy, OnChanges, OnInit, ApplicationRef, ChangeDetectorRef, ViewChild, ElementRef } from '@angular/core';
import { ComponentBase } from './ComponentBase';
import { MetaFormCreator } from './mataFormCreator';
import { NzMessageService } from 'ng-zorro-antd';

let replaceAll = function (str, s1, s2) {
  return str.replace(new RegExp(s1, "gm"), s2);
}
@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent extends ComponentBase implements OnInit, OnChanges, OnDestroy {
  // 储存数据用
  saveKey = "cartoon_video";

  item = {
    title: "",
    tipSwitch: 1,
    audio: "",
    imgAni: {
      ske: {},
      tex: {},
      png: {}
    },
    video_url: "",
  };

  constructor(public nzMessageService: NzMessageService, public appRef: ApplicationRef, public changeDetectorRef: ChangeDetectorRef) {
    super(appRef, changeDetectorRef);
  }
  init(): void {
  }

  ngChange(i, j) {
    this.save();
  }

  onDragonBoneSave(e, item) {
    console.log(e);
    this.save();
  }

  onVideoUploaded(evt) {
    this.item.video_url = evt.url;
    console.log(evt);
    this.save();
  }

  customRadioChange(e, item, key) {
    item[key] = e;
    this.save();
  }

}