// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

import movement from "./movements";

const { ccclass, property } = cc._decorator;
interface Point {
    id: string;
    blue_x: string;
    blue_y: string;
    yellow_x: string;
    yellow_y: string;
}
@ccclass
export default class NewClass extends cc.Component {
    @property
    isRobot: boolean = false;

    // LIFE-CYCLE CALLBACKS:
    onLoad() {
    }
    protected onDestroy(): void {
        cc.Tween.stopAll();
        this.unscheduleAllCallbacks();
    }
    private lastPoints: Array<Point>;
    run(points: Array<Point>) {
        return new Promise((resolve, reject) => {
            this.lastPoints = points;
            let posArray = this.getPos(points);
            let point0 = posArray.shift();
            this.node.x = point0.x;
            this.node.y = point0.y;
            let movementList = []
            for (let i = 0; i < posArray.length; i++) {
                let pos = posArray[i];
                movementList.push({
                    id: i,
                    time: 0.4,
                    x: pos.x,
                    y: pos.y,
                    audionode: "star"
                })
            }
            movement.loadTween(this.node, movementList).then(() => {
                resolve('');
            })
        });
    }
    getPos(points: Array<Point>) {
        let posArray = points.map(li => {
            let pos: any = {
                x: this.isRobot ? li.blue_x : li.yellow_x,
                y: this.isRobot ? li.blue_y : li.yellow_y
            }
            pos.x = Number(pos.x);
            pos.y = Number(pos.y);
            return pos;
        });
        return posArray;
    }
    // update (dt) {}
}
