// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    // LIFE-CYCLE CALLBACKS:

    private aning;
    onLoad() {
        this.aning = false;
    }
    protected onDestroy(): void {
        cc.Tween.stopAll();
        this.unscheduleAllCallbacks();
    }
    showAni() {
        if (this.aning) return;
        if (this.node && this.node.active) {
            this.node.x += 400;
            this.node.y -= 200;
            this.aning = true;
            cc.tween(this.node).by(0.3, { x: -400, y: 200 }).delay(1.5).call(() => {
                this.aning = false;
                this.showAni();
            }).start();
        }
    }
    update(dt) {
        this.showAni();
    }
}
