import pg from '"./tool/pg"'
// [
// 	{
// 		"id": 1,
// 		"time": 3,
// 		"delay": true
// 	},
// 	{
// 		"id": 2,
// 		"time": 3,
// 		"x": -445,
// 		"y": 193
// 	},
// 	{
// 		"id": 3,
// 		"time": 3,
// 		"delay": 0.2
// 	},
// 	{
// 		"id": 4,
// 		"time": 0,
// 		"aniname" : "normal"
// 	},
// 	{
// 		"id": 5,
// 		"time": 1,
// 		"delay": true
// 	},
// 	{
// 		"id": 6,
// 		"time": 0,
// 		"aniname" : "wrong"
// 	},
// 	{
// 		"id": 7,
// 		"time": 0,
// 		"audionode" : "sahua"
// 	}
// ]
class Movement {
    loadTween(node, movementList) {
        return new Promise((resolve, reject) => {
            let tween = cc.tween(node);
            movementList.forEach(moment => {
                if (moment.delay) this.loadDelay(tween, moment.time);
                // if (moment.aniname) this.loadDBArmature(tween, moment);
                if (moment.audionode) this.loadAudio(node, tween, moment);
                this.loadCCNode(tween, moment);
            });
            tween.call(() => {
                setTimeout(() => { resolve(''); }, 0);
            })
            tween.start();
        });
    }
    //延迟处
    private loadDelay(tween, time) {
        tween.delay(time)
    }
    //拓展cc.node对应的属性处理
    private loadCCNode(tween, moment) {
        let obj: any = {};
        if (moment.delay) return;//有等待不执行其他操作
        if (moment.x && moment.x != "" && moment.y && moment.y != "") {
            obj.position = cc.v2(moment.x, moment.y);
        }
        tween.to(moment.time, obj)
    }
    private loadDBArmature(tween, moment) {
        // tween.delay(0)
        // tween.call(() => {
        //     pg.animation.playDragonBone(this.node, moment.aniname);
        // })
    }
    private loadAudio(node, tween, moment) {
        tween.delay(0)
        tween.call(() => {
            let audioNode = node.getChildByName(moment.audionode);
            let audioClip = audioNode.getComponent(cc.AudioSource).clip;
            cc.audioEngine.play(audioClip, false, 1);
        })
    }
}
let movement = new Movement();
export default movement;