import pg from "./tool/pg";
const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    // LIFE-CYCLE CALLBACKS:
    private player: cc.Node;
    private robot: cc.Node;
    onLoad() {
        this.player = pg.view.find(this, "player");
        this.robot = pg.view.find(this, "robot");

        pg.event.on("player_point_update", (data) => {
            this.updatePlayer(data.isRobot, data.num);
            this.updateRobot(data.isRobot, data.num);
        })
    }
    protected onDestroy(): void {
        pg.event.off("player_point_update");
    }
    updatePlayer(isRobot, num) {
        if (!isRobot && num >= 1 && num <= 6) {
            let icon_player = pg.view.find(this.player, "icon_player");
            let icon_player_dice = pg.view.find(this.player, "icon_player_dice");
            pg.view.visible(icon_player, false);
            pg.view.visible(icon_player_dice, true);
            for (let i = 1; i <= 6; i++) {
                let item = pg.view.find(icon_player_dice, "icon_" + i);
                pg.view.visible(item, i == num);
            }
        } else {
            let icon_player = pg.view.find(this.player, "icon_player");
            let icon_player_dice = pg.view.find(this.player, "icon_player_dice");
            pg.view.visible(icon_player, true);
            pg.view.visible(icon_player_dice, false);
        }
    }
    updateRobot(isRobot, num) {
        if (isRobot && num >= 1 && num <= 6) {
            let icon_robot = pg.view.find(this.robot, "icon_robot");
            let icon_robot_dice = pg.view.find(this.robot, "icon_robot_dice");
            pg.view.visible(icon_robot, false);
            pg.view.visible(icon_robot_dice, true);
            for (let i = 1; i <= 6; i++) {
                let item = pg.view.find(icon_robot_dice, "icon_" + i);
                pg.view.visible(item, i == num);
            }
        } else {
            let icon_robot = pg.view.find(this.robot, "icon_robot");
            let icon_robot_dice = pg.view.find(this.robot, "icon_robot_dice");
            pg.view.visible(icon_robot, true);
            pg.view.visible(icon_robot_dice, false);
        }
    }

    start() {

    }

    // update (dt) {}
}
