// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

import pg from "./tool/pg";

const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    // LIFE-CYCLE CALLBACKS:
    private text_tip: cc.Node;
    private btn_audio_start: cc.Node;
    private btn_audio_stop: cc.Node;
    private speak_ske: cc.Node;
    private bg_goodjob: cc.Node;
    private bg_tryagain: cc.Node;
    onLoad() {
        this.text_tip = pg.view.find(this, "text_tip");
        this.btn_audio_start = pg.view.find(this, "btn_audio_start");
        this.btn_audio_stop = pg.view.find(this, "btn_audio_stop");
        this.speak_ske = pg.view.find(this, "speak_ske");
        this.bg_goodjob = pg.view.find(this, "bg_goodjob");
        this.bg_tryagain = pg.view.find(this, "bg_tryagain");

        pg.view.visible(this.text_tip, false);
        pg.view.visible(this.btn_audio_start, false);
        pg.view.visible(this.btn_audio_stop, false);
        pg.view.visible(this.speak_ske, false);
        pg.view.visible(this.bg_goodjob, false);
        pg.view.visible(this.bg_tryagain, false);

        pg.view.touchOn(this.btn_audio_start, this.onTouchStart, this);
        pg.view.touchOn(this.btn_audio_stop, this.onTouchStop, this);
        this.tryCount = 0;

        pg.event.on("speak_open", (data) => {
            cc.log("speak_open");
            this.tryCount = 0;
            this.open(data)
        })
    }

    protected onDestroy(): void {
        pg.event.off("speak_open");
        cc.Tween.stopAll();
        this.unscheduleAllCallbacks();
    }
    private tryCount: number;
    private val: string;
    open(cell) {
        if (cell) {
            this.val = cell.value;
        }
        pg.view.visible(this.text_tip, true);
        pg.view.visible(this.btn_audio_start, true);
        pg.view.visible(this.btn_audio_stop, false);
        pg.view.visible(this.speak_ske, true);
        pg.view.visible(this.bg_goodjob, false);
        pg.view.visible(this.bg_tryagain, false);
    }
    close() {
        pg.view.visible(this.text_tip, false);
        pg.view.visible(this.btn_audio_start, false);
        pg.view.visible(this.btn_audio_stop, false);
        pg.view.visible(this.speak_ske, false);
        pg.view.visible(this.bg_goodjob, false);
        pg.view.visible(this.bg_tryagain, false);
    }

    onTouchStart() {
        pg.view.playDBAnimation(this.speak_ske, "newAnimation", 0);
        pg.view.visible(this.btn_audio_start, false);
        pg.view.visible(this.btn_audio_stop, true);

        let win: any = window;
        win.courseware && win.courseware.startTest(this.val); //开始录音
    }
    onTouchStop() {
        pg.view.visible(this.btn_audio_start, false);
        pg.view.visible(this.btn_audio_stop, false);
        let win: any = window;
        if (!win.courseware) {
            this.scheduleOnce(() => {
                let data = {
                    "dtLastResponse": "2021-09-17 13:36:26:109",
                    "refText": "I haven't found anything out about him yet.",
                    "recordId": "6144295213f0a2200000ed93",
                    "eof": 1,
                    "result": {
                        "pronunciation": 25,
                        "resource_version": "3.1.0",
                        "fluency": 60,
                        "rhythm": 90,
                        "kernel_version": "5.2.4",
                        "overall": 75,
                        "integrity": 100,
                        "duration": "6.779",
                        "rear_tone": "fall",
                        "speed": 96,
                    },
                    "tokenId": "6144295408558b08dd000001",
                    "applicationId": "154838659000009e"
                };
                this.onRealStop(data.result.overall);
            }, 0.1)
        } else {
            win.courseware && win.courseware.stopTest((data: any) => {
                data = JSON.parse(data);
                this.onRealStop(data.result.overall);
            });
        }

    }
    onRealStop(score) {
        let db = pg.view.playDBAnimation(this.speak_ske, "newAnimation", 1);
        db.once(dragonBones.EventObject.COMPLETE, () => {
            pg.view.visible(this.text_tip, false);
            pg.view.visible(this.btn_audio_start, false);
            pg.view.visible(this.btn_audio_stop, false);
            pg.view.visible(this.speak_ske, false);
            pg.view.visible(this.bg_goodjob, false);
            pg.view.visible(this.bg_tryagain, false);
            if (score > 50) {
                pg.hw.playLocalAudio("goodjob");
                pg.view.visible(this.bg_goodjob, true);
                this.scheduleOnce(() => {
                    this.close();
                    pg.event.emit("speak_success");
                }, 2.5)
            } else {
                if (this.tryCount >= 1) {
                    pg.view.visible(this.bg_tryagain, true);
                    pg.hw.playLocalAudio("tryagain");
                    this.tryCount++;
                    //需要处理提供两次机会。重置一次到open状态
                    this.scheduleOnce(() => {
                        this.close();
                        pg.event.emit("speak_fail");
                    }, 2.5)
                } else {
                    pg.view.visible(this.bg_tryagain, true);
                    pg.hw.playLocalAudio("tryagain");
                    this.tryCount++;
                    this.scheduleOnce(() => {
                        this.open(null);
                    }, 2.5)
                }
            }
        })


    }

    start() {

    }

    // update (dt) {}
}
