import pg from "./tool/pg";

const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    // LIFE-CYCLE CALLBACKS:

    onLoad() {
        this.initView();
        let panel_gray = pg.view.find(this, "panel_gray");
        let btn_start = pg.view.find(this, "btn_start");
        let btn_restart = pg.view.find(this, "btn_restart");
        let bg_vs = pg.view.find(this, "bg_vs");
        pg.view.touchOn(btn_start, this.onTouchStart, this);
        pg.view.touchOn(btn_restart, this.onTouchRestart, this);
        pg.event.on("game_over", () => {
            this.onGameOver();
        })
    }
    protected onDestroy(): void {
        pg.event.off("game_over");
        cc.Tween.stopAll();
        this.unscheduleAllCallbacks();
    }
    initView() {
        let panel_gray = pg.view.find(this, "panel_gray");
        let btn_start = pg.view.find(this, "btn_start");
        let btn_restart = pg.view.find(this, "btn_restart");
        let bg_vs = pg.view.find(this, "bg_vs");
        pg.view.visible(panel_gray, true);
        pg.view.visible(btn_start, true);
    }
    onTouchStart() {
        pg.hw.playLocalAudio("vs");
        let panel_gray = pg.view.find(this, "panel_gray");
        let btn_start = pg.view.find(this, "btn_start");
        let btn_restart = pg.view.find(this, "btn_restart");
        let bg_vs = pg.view.find(this, "bg_vs");
        pg.view.visible(panel_gray, true);
        pg.view.visible(btn_start, false);
        pg.view.visible(bg_vs, true);
        if (bg_vs) {
            bg_vs.y = 1000;
            cc.tween(bg_vs).to(0.2, { y: 0 }).start();
        }
        pg.event.emit("game_start");
        this.scheduleOnce(() => {
            pg.view.visible(bg_vs, false);
            pg.view.visible(panel_gray, false);
        }, 2)
    }
    onTouchRestart() {
        pg.hw.playLocalAudio("vs");
        let panel_gray = pg.view.find(this, "panel_gray");
        let btn_start = pg.view.find(this, "btn_start");
        let btn_restart = pg.view.find(this, "btn_restart");
        let bg_vs = pg.view.find(this, "bg_vs");
        pg.view.visible(panel_gray, true);
        pg.view.visible(btn_start, false);
        pg.view.visible(btn_restart, false);
        pg.view.visible(bg_vs, true);
        this.scheduleOnce(() => {
            pg.view.visible(bg_vs, false);
            pg.view.visible(panel_gray, false);
            pg.view.visible(btn_restart, false);
            pg.event.emit("game_start");
        }, 2)
    }
    onGameOver() {
        let panel_gray = pg.view.find(this, "panel_gray");
        let btn_restart = pg.view.find(this, "btn_restart");
        let bg_vs = pg.view.find(this, "bg_vs");
        pg.view.visible(panel_gray, true);
        pg.view.visible(btn_restart, true);
    }
    update(dt) { }
}
