import map from "./map";
export class Item {
    public audio;
    public img;
    public text;
    public time;
    public tip;
    public id;
    constructor(data, id) {
        this.id = id;
        this.audio = data.audio;
        this.img = data.image;
        this.text = data.text;
        this.time = Number(data.time);
        this.tip = data.tip;
    }
}
class Role {
    public score: number;
    public error: number;
    constructor() {
        this.score = 0;
        this.error = 0;
    }
    addScore(score: number = 1) {
        this.score += score;
    }
    addError(score: number = 1) {
        this.error += score;
    }
}
export class Player extends Role {
    constructor() {
        super();
    }
    reset() {
        this.score = 0;
        this.error = 0;
    }
}
export class Robot extends Role {
    constructor() {
        super();
    }
    reset() {
        this.score = 0;
        this.error = 0;
    }
}
export default class Game {
    private static ins: Game;
    public static getIns(): Game {
        if (!Game.ins) Game.ins = new Game();
        return Game.ins;
    }
    private data: any;
    private lists: Array<Item>
    public player: Player;

    public robot: Robot;
    public bgm: string;

    constructor() {
        this.start = false;
        this.lists = [];
        this.player = new Player();
        this.robot = new Robot();
    }
    get len() {
        return this.lists.length;
    }
    public singleGame: boolean;
    public question: { text, audio };
    public title: string;
    public init(data) {
        this.singleGame = !data.onlineFlg;
        this.question = { text: data.questionText, audio: data.questionTextAudio };
        this.title = data.title;
        this.start = false;
        this.lists = [];
        this.bgm = data.bgAudio;
        this.data = data.options;
    }
    public start: boolean;
    public page: number;
    reset() {
        this.player.reset();
        this.robot.reset();
        this.page = 1;
        this.start = true;
        this.lists = [];
        for (let i = 0; i < this.data.length; i++) {
            let data = this.data[i];
            this.lists.push(new Item(data, i + 1));
        }
        this.lists.forEach((item) => {
        })
    }

    getMap() {
        return map;
    }
}