// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

import pg from "./tool/pg";

const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    // LIFE-CYCLE CALLBACKS:
    private bg_1: cc.Node;
    private bg_2: cc.Node;
    private bg_3: cc.Node;
    private bg_4: cc.Node;
    private bg_5: cc.Node;
    private bg_6: cc.Node;
    private bg_dice1: cc.Node;
    private bg_dice2: cc.Node;
    private bg_dice3: cc.Node;
    private bg_dice4: cc.Node;
    private bg_dice5: cc.Node;
    private bg_dice6: cc.Node;
    onLoad() {
        this.bg_1 = pg.view.find(this, "bg_1");
        this.bg_2 = pg.view.find(this, "bg_2");
        this.bg_3 = pg.view.find(this, "bg_3");
        this.bg_4 = pg.view.find(this, "bg_4");
        this.bg_5 = pg.view.find(this, "bg_5");
        this.bg_6 = pg.view.find(this, "bg_6");
        this.bg_dice1 = pg.view.find(this, "bg_dice1");
        this.bg_dice2 = pg.view.find(this, "bg_dice2");
        this.bg_dice3 = pg.view.find(this, "bg_dice3");
        this.bg_dice4 = pg.view.find(this, "bg_dice4");
        this.bg_dice5 = pg.view.find(this, "bg_dice5");
        this.bg_dice6 = pg.view.find(this, "bg_dice6");
    }
    protected onDestroy(): void {
        cc.Tween.stopAll();
        this.unscheduleAllCallbacks();
    }
    private playing: boolean;
    private num: number;
    startAni() {
        this.playing = true;
        this.num = null;
    }
    stopAni(number) {
        return new Promise((resolve, reject) => {
            this.num = number;
            this.playing = false;
            this.scheduleOnce(() => {
                resolve('');
            }, 1.5)
        });
    }
    start() {

    }
    updatePoint(number) {
        if (!number) return;
        if (this.num) {
            for (let i = 1; i <= 6; i++) {
                pg.view.visible(this[`bg_${i}`], false)
            }
            for (let i = 1; i <= 6; i++) {
                pg.view.visible(this[`bg_dice${i}`], i == number)
            }
        } else {
            for (let i = 1; i <= 6; i++) {
                pg.view.visible(this[`bg_${i}`], i == number)
            }
            for (let i = 1; i <= 6; i++) {
                pg.view.visible(this[`bg_dice${i}`], false)
            }
        }
    }
    update(dt) {
        if (!this.node || !this.node.active) return;
        if (this.playing) {
            let i = Math.floor(Math.random() * 6) + 1;
            this.updatePoint(i);
        } else {
            this.updatePoint(this.num);
        }
    }
}
