import { Component, OnDestroy, OnChanges, OnInit, ApplicationRef, ChangeDetectorRef, ViewChild, ElementRef } from '@angular/core';
import { ComponentBase } from './ComponentBase';
import { MetaFormCreator } from './mataFormCreator';

@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent extends ComponentBase implements OnInit, OnChanges, OnDestroy {
  // 储存数据用
  saveKey = "ns20_jsqj";

  //最多25个选项
  item = {
    onlineFlg: false,
    title: "急速前进",
    questionText: `亲爱的小玩家，在本次的游戏中，你将和其他玩家进行PK。每人拥有一颗棋子，放置在地图起点位置。两位玩家轮流扔骰子，根据骰子的点数，在地图上移动相应的步数，每到达一个地点，将要完成相应的任务。任务完成，棋子可以停留，否则，棋子需要退回上一个地点。最后，最先到达终点的玩家，获得胜利。
    游戏结束，根据你的表现，你将获得相应的能量石奖励！开始挑战吧！`,
    questionTextAudio: "http://staging-teach.cdn.ireadabc.com/e976f22632fea6f542ea3cf611e43ff9_l.mp3",
    options: [],
    bgAudio: "",
    audioBgName: "",
    audioName: "急速前进"
  };

  deleteBgAudio() {
    this.item.bgAudio = "";
    this.item.audioBgName = "";
    this.save();
  }
  isVisible = false;
  deleteTitle = "是否删除题目";
  deleteCallback = function () { };
  openDelete(title, callback) {
    this.deleteCallback = callback;
    this.deleteTitle = title;
    this.isVisible = true;
  }
  handleCancel() {
    this.isVisible = false;
  }
  handleOk() {
    this.deleteCallback && this.deleteCallback();
    this.handleCancel();
  }


  init(): void {
    console.log(new MetaFormCreator().create());
  }

  removeoption(j) {
    this.openDelete("确定删除选项？", () => {
      this.item.options.splice(j, 1);
      this.save();
    })
  }
  copyOption(j) {
    let data = this.item.options[j];
    this.item.options.push(JSON.parse(JSON.stringify(data)));
    this.save();
  }

  addoption() {
    this.item.options.push({
      image: "",
      audio: "",
      audioName: "",
      text: "",
      time: '',
      tip: ''
    });
    this.save();
  }

  ngChange() {
    this.save();
  }
}