/****
 * 批量编译打包模板工具
 * 运行 npm run publish T_01 命令来打包T_01模板
 * 运行 npm run publish T_01,T_02,T_03,T_04  命令来分别打包 T_01,T_02,T_03,T_04 这四个模板，注意逗号要用英文的
 * 运行 npm run publish all 命令来打包所有模板
 */
  
const path = require("path");
const fs = require("fs");
const os = require('os');
const compressing = require("compressing");

//Linux系统上'Linux'
//macOS 系统上'Darwin' 
//Windows系统上'Windows_NT'
let sysType = os.type(); 

Date.prototype.Format = function(fmt) {
  var o = {
      "M+" : this.getMonth() + 1,
      "d+" : this.getDate(),
      "h+" : this.getHours(),
      "m+" : this.getMinutes(),
      "s+" : this.getSeconds(),
      "q+" : Math.floor((this.getMonth() + 3) / 3),
      "S" : this.getMilliseconds()
  };
  if (/(y+)/.test(fmt))
      fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
  for (var k in o)
  if (new RegExp("(" + k + ")").test(fmt))
      fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
  return fmt;
}

function clean(zipPath){
  if(fs.existsSync(zipPath)){
    fs.unlinkSync(zipPath);
  }
}

var copy=function(src,dst){
  let paths = fs.readdirSync(src); //同步读取当前目录
  paths.forEach(function(path){
      var _src=src+'/'+path;
      var _dst=dst+'/'+path;
      fs.stat(_src,function(err,stats){  //stats  该对象 包含文件属性
          if(err)throw err;
          if(stats.isFile()){ //如果是个文件则拷贝 
              let readable=fs.createReadStream(_src);//创建读取流
              let writable=fs.createWriteStream(_dst);//创建写入流
              readable.pipe(writable);
          }else if(stats.isDirectory()){ //是目录则 递归 
              checkDirectory(_src,_dst,copy);
          }
      });
  });
}
var checkDirectory=function(src,dst,callback){
  fs.access(dst, fs.constants.F_OK, (err) => {
      if(err){
          fs.mkdirSync(dst);
          callback(src,dst);
      }else{
          callback(src,dst);
      }
    });
}; 

const runSpawn = async function (){ 

  checkDirectory(path.resolve(__dirname,"../form"), path.resolve(__dirname,"../dist/form"),copy); 
  checkDirectory(path.resolve(__dirname,"../index"), path.resolve(__dirname,"../dist/index"),copy); 
  checkDirectory(path.resolve(__dirname,"../lib"), path.resolve(__dirname,"../dist/lib"),copy);   
  await new Promise(function(resolve,reject){ 

    let pkg = require("../package.json"); 

    //要压缩的目录
    let zippath = path.resolve(__dirname,"../dist");  
    //压缩包的存放目录
    let date = new Date();
    let zipname = pkg.name+"_"+date.Format("yyyyMMdd hh-mm-ss");
    let zipdir = path.resolve(__dirname,"../publish/"+zipname+".zip");
    clean(zipdir); //删除原有的包
  
    const tarStream = new compressing.zip.Stream();
    fs.readdir(zippath,function(err,files){
      if(err){
        console.log("======文件打开异常======");
        console.log(err);
        reject();
      }
      for(let i=0;i<files.length;i++){
        tarStream.addEntry(zippath+"/"+files[i]);
      }
      let writeStream = fs.createWriteStream(zipdir);
      tarStream.pipe(writeStream); 
      writeStream.on('close', () => {
          console.log(`模板 ${pkg.name} 打包已完成！`);
          resolve();
      })
    });  

  }); 
}

// let projects = "";
// if(process.argv.length<3){
//   console.log("缺少参数");
//   return;
// }
// projects = process.argv[2];  

let exec = async function(){
  //压缩模板
  await runSpawn();
}

exec();

 

 