import {Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef} from '@angular/core';
import {NzMessageService} from "ng-zorro-antd";



@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {

  // 储存数据用
  saveKey = 'OP-06-1';
  // 储存对象
  item;

  bgItem = {};
  hotZoneItemArr = [];
  animaArr = [];

  picArr;



  constructor(private appRef: ApplicationRef,
              private changeDetectorRef: ChangeDetectorRef,
              private message: NzMessageService) {

  }


  ngOnInit() {

    this.item = {
      video_url: '',
      begin_audio_url: '',
      finish_audio_url: '',
    };


    // 获取存储的数据
    (<any> window).courseware.getData((data) => {
      // console.log(1, data);
      if (data) {
        this.item = data;
        // console.log(2, data);
      }

      this.init();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();

    }, this.saveKey);

  }


  ngOnChanges() {
  }

  ngOnDestroy() {
  }

  onVideoUploaded(evt) {
    this.item.video_url = evt.url;
    console.log(evt);
    this.save();
  }
  onBeginUploaded(evt) {
    this.item.begin_audio_url = evt.url;
    console.log(evt);
    this.save();
  }
  onFinishUploaded(evt) {
    this.item.finish_audio_url = evt.url;
    console.log(evt);
    this.save();
  }
  onHintUploaded(evt) {
    this.item.hint_audio_url = evt.url;
    console.log(evt);
    this.save();
  }
  init() {

  }




  save() {

    console.log('this.item: ', this.item);
    console.log('this.item json: ', JSON.stringify(this.item) );
    (<any> window).courseware.setData(this.item, null, this.saveKey);
    this.refresh();
  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }


}

