 import {
  Component,
  Input,
  OnDestroy,
  OnChanges,
  OnInit,
  AfterViewInit, ElementRef, ViewChild,
} from '@angular/core'; 

import * as _ from 'lodash';

@Component({
  selector: 'app-play',
  templateUrl: './play.component.html',
  styleUrls: ['./play.component.scss']
})
export class PlayComponent implements OnInit, OnDestroy, OnChanges, AfterViewInit {

  @ViewChild('audioElement')
  audioElement: ElementRef;

  data = {
    contentObj:{titleObj:{
      audio_url: 'http://iplayabc-courseware.oss-cn-beijing.aliyuncs.com/dev/imman/audios/d108d5d06105fda0526059a3e372f926.mp3',
      content: 'what is this?&nbsp;',
      icons: [],
      type: 'a'
    }}
  }; 

  letters = [];
  lettersAscii = {};
  titleAudio = null;
  showDetailFlag = false;
  curItemUrl = '';
  curEvt;

  constructor() {

  }
  range(start, end) {
    return (new Array(end - start + 1)).fill(undefined).map((_, i) => i + start);
  }
  ngOnInit() {  

    let _this = this;
    (<any>window).courseware.getData(function(data){ 
      if(data){
        _this.data.contentObj.titleObj = data;
      }
    });
    
    // const letters = _.shuffle( [...this.range(97, 122), ...this.range(65, 90)]);
    [...this.range(97, 122), ...this.range(65, 90)].forEach(c => {
      this.lettersAscii[c] = String.fromCharCode(c);
    });
    this.letters = _.shuffle(Object.keys(this.lettersAscii));

  }

  ngOnDestroy() {

  }

  ngOnChanges(data) {

  }

  ngAfterViewInit() {


  }


  clickItem(e, a) {

    this.curEvt = e;
    this.curItemUrl = 'assets/all-letters/letter-detail/' + a + '.png';
    this.showDetailFlag = true;
  }

  clickBg() {

    this.showDetailFlag = false;
  }

  clickBigItem(e) {

    e.cancelBubble = true;
    this.playLetterAudio(this.curEvt);
  }



  caseFolder(c) {
    let folder = 'upper';
    if (c.toLowerCase() === c) {
      folder = 'lower';
    }
    return `${folder}/${c}.png`;
  }
  row(i) {
    const r = Math.floor(i / 13);
    let y = (r * 20);
    switch (r) {
      case 0:
      case 1:
        y += 13;
        break;
      case 2:
      case 3:
        y += 15;
        break;
    }
    return y ;
  }
  lower(c) {
    return c.toLowerCase();
  }
  fromCharCode(c) {
    return String.fromCharCode(c).toLowerCase();
  }
  allLetters() {

  }
  playTitleAudio() {
    this.titleAudio = this.audioElement ? this.audioElement.nativeElement : null;
    if (!this.titleAudio) {
      return;
    }
    this.titleAudio.pause();
    this.titleAudio.currentTime = 0;
    this.titleAudio.play();
  }
  playLetterAudio(evt) {
    const audios = document.querySelectorAll('audio');
    for (let i = 0; i < audios.length; i++) {
      audios[i].pause();
      audios[i].currentTime = 0;
    }
    const a = evt.target.parentNode.querySelector('audio');
    // a.play();
    const playPromise = a.play();

    if (playPromise !== undefined) {
      playPromise.then(_ => {
        // Automatic playback started!
        // Show playing UI.
        console.log(1, _)
      })
        .catch(error => {
          // Auto-play was prevented
          // Show paused UI.
          console.log(2, error)
        });
    }
  }

}
