import { Component, OnDestroy, OnChanges, OnInit, ApplicationRef, ChangeDetectorRef, ViewChild, ElementRef } from '@angular/core';
import { ComponentBase } from './ComponentBase';
import { MetaFormCreator } from './mataFormCreator';

@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent extends ComponentBase implements OnInit, OnChanges, OnDestroy {
  // 储存数据用
  saveKey = "hy_04";

  item = {
    onlineFlg: false,
    npcTitle: "",
    npcAudio: "",
    npcAudioName: '',
    title: "",
    questionText: "",
    questionTextAudio: "",
    questions: [],
    bgAudio: "",
    bgAudioName: "",
    word_count: '0',
    sentence_count: '0',
    zi_count: '0',
    showKuang: '1',
    audioName: ""
  };
  isVisible = false;
  deleteTitle = "是否删除题目";
  deleteCallback = function () { };
  openDelete(title, callback) {
    this.deleteCallback = callback;
    this.deleteTitle = title;
    this.isVisible = true;
  }
  handleCancel() {
    this.isVisible = false;
  }
  handleOk() {
    this.deleteCallback && this.deleteCallback();
    this.handleCancel();
  }


  init(): void {
    if (!this.item.npcTitle) this.item.npcTitle = '';
    if (!this.item.npcAudio) this.item.npcAudio = '';
    if (!this.item.npcAudioName) this.item.npcAudioName = '';
    if (!this.item.word_count) this.item.word_count = '0';
    if (!this.item.sentence_count) this.item.sentence_count = '0';
    if (!this.item.zi_count) this.item.zi_count = '0';
    // console.log(new MetaFormCreator().create());
  }

  removeoption(i, j) {
    this.openDelete("确定减少选项？", () => {
      this.item.questions[i].letterList.splice(j, 1);
      this.save();
    })
  }
  copyOption(i, j) {
    let data = this.item.questions[i].letterList[j];
    this.item.questions[i].letterList.push(JSON.parse(JSON.stringify(data)));
    this.save();
  }

  addoption(i) {
    this.item.questions[i].letterList.push({
      text: ''
    })
    this.save();
  }

  removequestion(i) {
    this.openDelete("确定删除题目？", () => {
      this.item.questions.splice(i, 1);
      this.save();
    })
  }

  addquestion() {
    this.item.questions.push({
      questionAudio: "",
      duration: 120,
      type: "img",
      image: "",
      audio: "",
      text: "",
      right: false,
      letterList: [],
    });
    this.save();
  }

  deleteBgAudio() {
    this.item.bgAudio = "";
    this.item.bgAudioName = "";
    this.save();
  }
  ngChange(i) {
    this.save();
  }
}