import { Component, OnDestroy, OnChanges, OnInit, ApplicationRef, ChangeDetectorRef, ViewChild, ElementRef } from '@angular/core';
import { ComponentBase } from './ComponentBase';
import { MetaFormCreator } from './mataFormCreator';

let replaceAll = function (str, s1, s2) {
  return str.replace(new RegExp(s1, "gm"), s2);
}
@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent extends ComponentBase implements OnInit, OnChanges, OnDestroy {
  // 储存数据用
  saveKey = "sn04";

  item = {
    // imgAni: {
    //   ske: {},
    //   tex: {},
    //   png: {}
    // },
    // title: "急速滑雪",
    // questionText: "雪地里有许多不同的指示牌，运动员要选择哪一个呢？亲爱的小玩家，请你认真听游戏指令，帮助运动员选择正确的指示牌吧！游戏结束后，根据收集到的指示牌数量，你将获得相应的能量石奖励哟！开始挑战吧！",
    // questionTextAudio: "http://staging-teach.cdn.ireadabc.com/c3b69ad3d51385eac7d4195773ef59f7_l.mp3",
    questions: [],
    // tipSwitch: 1,//提示功能开关
    // startAudio: "",
    // audioName: "",
    title: "分类",
    time: 60,
    opleng: 0,
    word_count: '0',
    sentence_count: '0',
    zi_count: '0',
  };

  isVisible = false;
  deleteTitle = "是否删除题目";
  deleteCallback = function () { };
  openDelete(title, callback) {
    this.deleteCallback = callback;
    this.deleteTitle = title;
    this.isVisible = true;
  }
  handleCancel() {
    this.isVisible = false;
  }
  handleOk() {
    this.deleteCallback && this.deleteCallback();
    this.handleCancel();
  }
  init(): void {
    if (!this.item.word_count) this.item.word_count = '0';
    if (!this.item.sentence_count) this.item.sentence_count = '0';
    if (!this.item.zi_count) this.item.zi_count = '0';
    console.log(new MetaFormCreator().create());
  }
  updateOpleng() {
    let len = 0;
    this.item.questions.forEach((op) => {
      len += op.options.length;
    })
    this.item.opleng = len;
  }

  removeoption(i, j) {
    this.openDelete("确定删除选项？", () => {
      this.item.questions[i].options.splice(j, 1);
      this.updateOpleng();
      this.save();
    })
  }
  copyoption(i, j) {
    let data = this.item.questions[i].options[j];
    this.item.questions[i].options.push(JSON.parse(JSON.stringify(data)));
    this.updateOpleng();
    this.save();
  }

  addoption(i) {
    this.item.questions[i].options.push({
      type: "txt",
      image: "",
      audio: "",
      text: "",
      time: "",
      right: false
    });
    this.updateOpleng();
    this.save();
  }

  removequestion(idx) {
    this.openDelete("确定删除题目？", () => {
      this.item.questions.splice(idx, 1);
      this.updateOpleng();
      this.save();
    })
  }

  addquestion() {
    this.item.questions.push({
      options: [],
      type: "txt",
      text: "",
      questionAudio: "",
      // wordAudio: "",
      // wordAudioName: "",
      // audioName: "",
      image: "",
      contentMain: "",
      contentArr: [],
    });
    this.updateOpleng();
    this.save();
  }
  ngChange() {
    this.updateOpleng();
    this.save();
  }

  // changeMain(question) {
  //   //输出的数据可以识别到\n的换行符
  //   let arr = question.contentMain.split(" ");
  //   let oldArr = question.contentArr.concat();
  //   let contetArr = arr.map(ar => {
  //     let obj = {
  //       text: `${ar}`,//replaceAll(`${ar}`, "\n", "<br/>"),
  //       block: false,
  //       check: 1,
  //     }
  //     for (let i = 0; i < oldArr.length; i++) {
  //       if (obj.text == oldArr[i].text) {
  //         obj.block = oldArr[i].block;
  //         obj.check = oldArr[i].check;
  //         oldArr.splice(i, 1);
  //         break;
  //       }
  //     }
  //     return obj;
  //   })
  //   question.contentArr = contetArr;
  //   console.log(contetArr)
  //   this.save();
  // }
  // onBlock(item, vis) {
  //   item.block = vis;
  //   this.save();
  // }
  // onDragonBoneSave(e, item) {
  //   console.log(e);
  //   this.save();
  // }
}