// pg.event.emit('img_voice_play_voice_start')
// pg.event.emit('img_voice_play_voice_end')


import pg from "./pg_sn05_night";

const { ccclass, property } = cc._decorator;

@ccclass
export default class ImgVoice extends cc.Component {
    onLoad() {
        this.initView();
        this.initEvent();
    }
    protected onDestroy(): void {
        this.unscheduleAllCallbacks();
    }
    initView() {
    }
    initEvent() {
        pg.event.on('img_voice_play_voice_start', () => {
            this.playVoiceStart();
        })
        pg.event.on('img_voice_play_voice_end', () => {
            this.playVoiceEnd();
        })
    }
    private playVoiceCount: number;
    playVoiceStart() {
        if (this.playVoiceCount > 0) return;
        this.playVoiceCount = 0;
        this.playVoiceRunning();
        this.schedule(this.playVoiceRunning, 0.3)
    }
    playVoiceRunning() {
        if (!this.node) return;
        this.playVoiceCount++;
        let list = this.node.children;
        list.forEach((li, i) => {
            li.active = this.playVoiceCount % list.length == i;
        })
    }
    playVoiceEnd() {
        this.unschedule(this.playVoiceRunning)
        this.playVoiceCount = 0;
        let list = this.node.children;
        list.forEach((li, i) => {
            li.active = i == 0
        })
    }
}





