// pg.event.emit('npc_layer_back_init',{  })
// pg.event.emit('npc_voice_play_voice_start')
// pg.event.emit('npc_voice_play_voice_end')


import pg from "../../scene/pg_sn05_night";

const { ccclass, property } = cc._decorator;

@ccclass
export default class LayerBack extends cc.Component {
    private btn_back: cc.Node;
    private img_npc_voice: cc.Node;
    private bg_forbid: cc.Node;
    onLoad() {
        this.initView();
        this.initEvent();
    }
    private label_title: cc.Node;


    initView() {
        this.bg_forbid = pg.view.find(this, 'bg_forbid')
        this.btn_back = pg.view.find(this, 'btn_back')
        this.label_title = pg.view.find(this, 'label_title')
        this.img_npc_voice = pg.view.find(this.label_title, 'img_npc_voice')
        pg.view.touchOn(this.img_npc_voice, this.playVoiceStart, this);
    }
    private npcTitle: string;
    private npcAudio: string;
    updateView(data) {
        this.npcTitle = data.npcTitle
        this.npcAudio = data.npcAudio
        pg.view.visible(this.img_npc_voice, this.npcAudio)
        pg.view.visible(this.label_title, this.npcTitle)
        pg.view.setString(this.label_title, this.npcTitle);
    }
    initEvent() {
        pg.view.touchOn(this.btn_back, this.onTouchBack, this)
        pg.event.on('npc_layer_back_init', (data) => {
            this.updateView(data);
            if (!this.npcAudio) {
                pg.view.visible(this.bg_forbid, false)
                pg.event.emit('npc_voice_play_voice_end');
            } else {
                this.playVoiceStart();
            }
        })
    }
    private playVoiceCount: number;
    private audioId: number;
    playVoiceStart() {
        if (this.playVoiceCount > 0) {
            if (this.audioId) cc.audioEngine.stopEffect(this.audioId);
            this.playVoiceEnd();
        }
        this.playVoiceCount = 0;
        this.schedule(this.playVoiceRunning, 0.3)
        pg.audio.playAudioByUrl(this.npcAudio, () => {
            this.playVoiceEnd();
            pg.view.visible(this.bg_forbid, false)
            pg.event.emit('npc_voice_play_voice_end')
        }, (audioId) => {
            this.audioId = audioId;
        });
    }
    protected onDestroy(): void {
        this.unscheduleAllCallbacks();
    }
    playVoiceRunning() {
        if (!this.img_npc_voice) return;
        this.playVoiceCount++;
        let p1 = this.img_npc_voice.getChildByName('p1')
        let p2 = this.img_npc_voice.getChildByName('p2')
        let p3 = this.img_npc_voice.getChildByName('p3')
        p1.active = this.playVoiceCount % 3 == 0;
        p2.active = this.playVoiceCount % 3 == 1;
        p3.active = this.playVoiceCount % 3 == 2;
    }
    playVoiceEnd() {
        this.unschedule(this.playVoiceRunning)
        this.playVoiceCount = 0;
        let p1 = this.img_npc_voice.getChildByName('p1')
        let p2 = this.img_npc_voice.getChildByName('p2')
        let p3 = this.img_npc_voice.getChildByName('p3')
        p1.active = true;
        p2.active = false;
        p3.active = false;
    }
    onTouchBack() {
        const middleLayer = cc.find('middleLayer');
        const middleLayerComponent = middleLayer.getComponent('middleLayer');
        middleLayerComponent.exitGame();
    }
}







