export class MetaFormCreator {
  constructor() { }
  create() {
    const data = {
      onlineFlg: false, // 联机flg true联机版 false单机版
      title: "标题文本", // 标题文本
      questionText: "题目说明题目说明题目说明题目说明题目说明题目说明题目说明题目说明题目说明题目说明", // 题目说明
      questionTextAudio: "http://staging-teach.cdn.ireadabc.com/b1019dcdb1f089ba9a65b71a1f52f67a.mp3", // 题目说明的语音
      questions: [ // 题目，数组
        {
          questionAudio: "http://staging-teach.cdn.ireadabc.com/727a5af2f7ed99edb4a49d1126ecc9ca.mp3", // 题目音频
          duration: 120, // 游戏倒计时（秒）
          options: [ // 选项
            {
              type: "img",// 选项类型 img图片 txt文本
              image: "http://staging-teach.cdn.ireadabc.com/03531e7ca2278b291da7d27bc1d60868.png", // 图片地址
              audio: "http://staging-teach.cdn.ireadabc.com/727a5af2f7ed99edb4a49d1126ecc9ca.mp3", // 选项音频
              text: "", // 选项类型为图片时，此选项没啥用
              right: true // 这个选项是否是正确的
            },
            {
              type: "text",// 选项类型 img图片 txt文本
              image: "", // 选项类型为文本时，此选项没啥用
              text: "asasdf", // 选项文本
              audio: "http://staging-teach.cdn.ireadabc.com/727a5af2f7ed99edb4a49d1126ecc9ca.mp3",
              right: true
            },
            {
              image: "http://staging-teach.cdn.ireadabc.com/35bfd1d1342e1f2ea3db408afd072343.jpg",
              audio: "",
              type: "img",
              text: "",
              right: false
            },
            {
              image: "",
              audio: "",
              type: "text",
              text: "oliolioliooo",
              right: false
            }
          ]
        },
        {
          questionAudio: "http://staging-teach.cdn.ireadabc.com/727a5af2f7ed99edb4a49d1126ecc9ca.mp3",
          duration: 120, // 游戏倒计时（秒）
          options: [
            {
              image: "http://staging-teach.cdn.ireadabc.com/03531e7ca2278b291da7d27bc1d60868.png",
              audio: "http://staging-teach.cdn.ireadabc.com/727a5af2f7ed99edb4a49d1126ecc9ca.mp3",
              type: "img",
              text: "",
              right: true
            },
            {
              image: "",
              audio: "http://staging-teach.cdn.ireadabc.com/727a5af2f7ed99edb4a49d1126ecc9ca.mp3",
              type: "text",
              text: "olio",
              right: true
            },
            {
              image: "http://staging-teach.cdn.ireadabc.com/35bfd1d1342e1f2ea3db408afd072343.jpg",
              audio: "",
              type: "img",
              text: "",
              right: false
            },
            {
              image: "",
              audio: "",
              type: "text",
              text: "oliolioliooo",
              right: false
            }
          ]
        }
      ]
    };
    return this.createHtml(data, 'item', []);
  }

  createHtml(data: any, itemKey: string, idxList = []) {
    let result = '';
    for (const key in data) {
      if (typeof data[key] == 'boolean') {
        result += this.createBooleanHtml(itemKey, key);
      }
      if (typeof data[key] == 'number') {
        result += this.createNumberHtml(itemKey, key);
      }
      if (typeof data[key] === 'string') {
        if (key.includes('img') || key.includes('image')) {
          result += this.createImageHtml(itemKey, key);
        } else if (key.includes('Audio') || key.includes('audio')) {
          result += this.createAudioHtml(itemKey, key);
        } else {
          result += this.createTextHtml(itemKey, key);
        }
      }
      if (typeof data[key] == 'object') {
        if (data[key] instanceof Array) {
          result += this.createArrayHtml(itemKey, key, data[key], idxList);
        }
      }
    }
    return result;
  }

  createArrayHtml(itemName: string, key: string, data: any, idxList) {
    let itemKey = key;
    if (key[key.length - 1] == 's') {
      itemKey = key.substring(0, key.length - 1);
    }
    const idxStrList = ['i', 'j', 'k', 'l'];
    let idxStr = '';
    for (let i = 0; i < idxStrList.length; i++) {
      const str = idxStrList[i];
      if (!idxList.includes(str)) {
        idxStr = str;
        break;
      }
    }
    const subresult = this.createHtml(data[0], `${itemName}.${key}[${idxStr}]`, [...idxList, idxStr]);
    return `
    <div class="border" style="width: 800px;">
      <div *ngFor="let ${itemKey} of ${itemName}.${key}; let ${idxStr} = index">
        <div class="border" style="width: 700px;">
        ${subresult}
        <button style="width: 650px; height: 30px; color: red;" (click)="remove${itemKey}(${idxStr})">删除</button>
        </div>
      </div>

      <div class="border" style="width: 700px;">
        <button style="width: 650px; height: 100px;" (click)="add${itemKey}()">增加</button>
      </div>
    </div>`
  }

  createNumberHtml(itemName: string, key: string) {
    let dot = '.';
    if (itemName == '') {
      dot = '';
    }
    return `
    <span>数字: </span>
    <input type="number" nz-input [(ngModel)]="${itemName}${dot}${key}" (blur)="save()">`
  }

  createTextHtml(itemName: string, key: string) {
    let dot = '.';
    if (itemName == '') {
      dot = '';
    }
    return `
    <span>文本: </span>
    <input type="text" nz-input [(ngModel)]="${itemName}${dot}${key}" (blur)="save()">`
  }

  createAudioHtml(itemName: string, key: string) {
    let dot = '.';
    if (itemName == '') {
      dot = '';
    }
    let keyList = '';
    itemName.split('.').forEach(key => {
      keyList += `'${key}',`;
    });
    return `
    <span>音频: </span>
    <app-audio-recorder
      [audioUrl]="${itemName}${dot}${key}"
      (audioUploaded)="onAssetUploadSuccess($event, ${keyList}'${key}')"
    ></app-audio-recorder>`
  }

  createImageHtml(itemName: string, key: string) {
    let dot = '.';
    if (itemName == '') {
      dot = '';
    }
    let keyList = '';
    itemName.split('.').forEach(key => {
      keyList += `'${key}',`;
    });
    return `<span>图片: </span>
    <app-upload-image-with-preview
      [picUrl]="${itemName}${dot}${key}"
      (imageUploaded)="onAssetUploadSuccess($event, ${keyList}'${key}')">
    </app-upload-image-with-preview>`;
  }

  createBooleanHtml(itemName: string, key: string) {
    let dot = '.';
    if (itemName == '') {
      dot = '';
    }
    return `
    <span style="font-size: 20px;">答案：</span>
    <div *ngIf="${itemName}${dot}${key}==true">
      <button class="button-right">正确</button>
      &nbsp;
      <button class="button-disable" (click)="${itemName}${dot}${key} = false;save();">错误</button>
    </div>
    <div *ngIf="${itemName}${dot}${key}==false">
      <button class="button-disable" (click)="${itemName}${dot}${key} = true;save();">正确</button>
      &nbsp;
      <button class="button-wrong">错误</button>
    </div>
    <br>`
  }
}