// pg.event.emit('layer_coin_show_coin',1)   //1 2 3硬币数量
// pg.event.once('layer_coin_show_coin_end',()=>{})  // 动画回调


import pg from "../../scene/pg_sn19_read";
const { ccclass, property } = cc._decorator;


@ccclass
export default class LayerCoin extends cc.Component {

    private layout_center;
    onLoad() {
        pg.event.on('layer_coin_show_coin', (num) => { this.showCoin(num) });
        this.layout_center = pg.view.find(this, 'layout_center')
    }

    showCoin(num) {
        pg.view.visible(this.layout_center, true)
        let coinAni = null;
        pg.view.visible(pg.view.find(this.layout_center, "aniNode1"), false)
        pg.view.visible(pg.view.find(this.layout_center, "aniNode2"), false)
        pg.view.visible(pg.view.find(this.layout_center, "aniNode3"), false)
        switch (num) {
            case 1:
                coinAni = pg.view.find(this.layout_center, "aniNode1");
                coinAni.active = true;
                pg.view.addEventDBAnimation(coinAni, this.hideCoin, this);
                pg.view.playDBAnimation(coinAni, "one", 1);
                this.playLocalAudio('coin');
                break;
            case 2:
                coinAni = pg.view.find(this.layout_center, "aniNode2");
                coinAni.active = true;
                pg.view.addEventDBAnimation(coinAni, this.hideCoin, this);
                pg.view.playDBAnimation(coinAni, "two", 1);
                this.playLocalAudio('coin');
                this.scheduleOnce(() => {
                    this.playLocalAudio('coin');
                }, 0.3)
                break;
            case 3:
                coinAni = pg.view.find(this.layout_center, "aniNode3");
                coinAni.active = true;
                pg.view.addEventDBAnimation(coinAni, this.hideCoin, this);
                pg.view.playDBAnimation(coinAni, "three", 1);
                this.playLocalAudio('coin');
                this.scheduleOnce(() => {
                    this.playLocalAudio('coin');
                }, 0.3)
                this.scheduleOnce(() => {
                    this.playLocalAudio('coin');
                }, 0.6)
                break;
        }

    }
    hideCoin() {
        this.scheduleOnce(() => {
            pg.view.visible(this.layout_center, false)
            pg.event.emit('layer_coin_show_coin_end')
        }, 1.0)
    }
    playLocalAudio(name) {
        let ending = pg.view.find(this, `res/${name}`)
        pg.audio.playLocalAudio(ending)
    }
}






