// pg.event.once('layer_right_show_excellent_end', () => {
//     alert('test')
// })
// pg.event.emit('layer_right_show_excellent')
// pg.event.once('layer_right_show_good_end', () => {
//     alert('test')
// })
// pg.event.emit('layer_right_show_good')
// pg.event.once('layer_right_show_tryagain_end', () => {
//     alert('test')
// })
// pg.event.emit('layer_right_show_tryagain')


import pg from "../../scene/pg_sn19_read";

const { ccclass, property } = cc._decorator;

@ccclass
export default class LayerRight extends cc.Component {
    onLoad() {
        this.initData();
        this.initEvent();
    }
    initData() {

    }
    initEvent() {
        pg.event.on('layer_right_show_excellent', () => {
            this.showExcellent();
            // pg.event.emit('layer_right_show_excellent_end');
        })
        pg.event.on('layer_right_show_good', () => {
            this.showGood();
            // pg.event.emit('layer_right_show_good_end');
        })
        pg.event.on('layer_right_show_tryagain', () => {
            this.showTryagain();
            // pg.event.emit('layer_right_show_tryagain_end');
        })
    }
    showExcellent() {
        this.playLocalAudio('ani')
        this.scheduleOnce(() => {
            this.playLocalAudio('excellent')
        }, 0.2)
        let layout_excellent = pg.view.find(this, 'layout_excellent');
        let layout_good = pg.view.find(this, 'layout_good');
        let layout_tryagain = pg.view.find(this, 'layout_tryagain');
        layout_excellent.active = true;
        layout_good.active = false;
        layout_tryagain.active = false;

        let aniNode = pg.view.find(layout_excellent, 'AniNode');
        pg.view.playDBAnimation(aniNode, 'newAnimation', 0)
        pg.view.addEventDBAnimation(aniNode, () => {
            layout_excellent.active = false;
            pg.event.emit('layer_right_show_excellent_end');
        }, this)
    }
    showGood() {
        this.playLocalAudio('ani')
        this.scheduleOnce(() => {
            this.playLocalAudio('good')
        }, 0.2)
        let layout_excellent = pg.view.find(this, 'layout_excellent');
        let layout_good = pg.view.find(this, 'layout_good');
        let layout_tryagain = pg.view.find(this, 'layout_tryagain');
        layout_excellent.active = false;
        layout_good.active = true;
        layout_tryagain.active = false;

        let aniNode = pg.view.find(layout_good, 'AniNode');
        pg.view.playDBAnimation(aniNode, 'newAnimation', 1)
        pg.view.addEventDBAnimation(aniNode, () => {
            layout_good.active = false;
            pg.event.emit('layer_right_show_good_end');
        }, this)
    }
    showTryagain() {
        this.playLocalAudio('ani')
        this.scheduleOnce(() => {
            this.playLocalAudio('tryagain')
        }, 0.2)
        let layout_excellent = pg.view.find(this, 'layout_excellent');
        let layout_good = pg.view.find(this, 'layout_good');
        let layout_tryagain = pg.view.find(this, 'layout_tryagain');
        layout_excellent.active = false;
        layout_good.active = false;
        layout_tryagain.active = true;

        let aniNode = pg.view.find(layout_tryagain, 'AniNode');
        pg.view.playDBAnimation(aniNode, 'newAnimation', 1)
        pg.view.addEventDBAnimation(aniNode, () => {
            layout_tryagain.active = false;
            pg.event.emit('layer_right_show_tryagain_end');
        }, this)
    }


    playLocalAudio(audioName, loop = false) {
        console.log("play audio->" + audioName);
        const audio = pg.view.find(this, `voice/${audioName}`).getComponent(cc.AudioSource);
        return new Promise((resolve, reject) => {
            const id = cc.audioEngine.playEffect(audio.clip, loop);
            resolve(id);
        })
    }
}





