// pg.event.emit('img_voice_play_voice_start')
// pg.event.emit('img_voice_play_voice_end')

import pg from "./pg_sn19_read";

const { ccclass, property } = cc._decorator;

@ccclass
export default class ImgAuto extends cc.Component {
    onLoad() {
        this.initEvent();
    }
    protected onDestroy(): void {
        this.unscheduleAllCallbacks();
    }
    initEvent() {
        pg.event.on('img_voice_play_voice_start', () => {
            this.playVoiceStart();
        })
        pg.event.on('img_voice_play_voice_end', () => {
            this.playVoiceEnd();
        })
    }
    private playVoiceCount: number;
    playVoiceStart() {
        if (this.playVoiceCount > 0){
            this.playVoiceEnd();
        }
        this.playVoiceCount = 0;
        this.schedule(this.playVoiceRunning, 0.3)
    }
    playVoiceRunning() {
        this.playVoiceCount++;
        if (!this.node) return;
        let p1 = this.node.getChildByName('p1')
        let p2 = this.node.getChildByName('p2')
        let p3 = this.node.getChildByName('p3')
        p1.active = this.playVoiceCount % 3 == 0;
        p2.active = this.playVoiceCount % 3 == 1;
        p3.active = this.playVoiceCount % 3 == 2;
    }
    playVoiceEnd() {
        this.unschedule(this.playVoiceRunning)
        this.playVoiceCount = 0;
        let p1 = this.node.getChildByName('p1')
        let p2 = this.node.getChildByName('p2')
        let p3 = this.node.getChildByName('p3')
        p1.active = true;
        p2.active = false;
        p3.active = false;
    }
}





