import pg from "./pg_sn19_read";

const { ccclass, property } = cc._decorator;

@ccclass
export default class LayoutTip extends cc.Component {
    public static readonly LAYOUT_TIP_TYPE = {
        LAYOUT_TIP_TYPE_NONE: 0,
        LAYOUT_TIP_TYPE_WRONG: 1,
        LAYOUT_TIP_TYPE_RIGHT: 2,
        LAYOUT_TIP_TYPE_EXCELLENT: 3,
        LAYOUT_TIP_TYPE_GOOD: 4,
        LAYOUT_TIP_TYPE_TRYAGAIN: 5,
    }
    @property(cc.Node) img_wrong: cc.Node = null;
    @property(cc.Node) img_right: cc.Node = null;
    @property(cc.Node) img_excellent: cc.Node = null;
    @property(cc.Node) img_good: cc.Node = null;
    @property(cc.Node) img_tryagain: cc.Node = null;
    @property(cc.Node) btn_close: cc.Node = null;
    @property(cc.Node) label_rich: cc.Node = null;

    private delayCtrl: any;
    open(gameType, data, touchAuto) {
        return new Promise(async (resolve, reject) => {
            this.node.active = true;
            this.initEvent();
            this.showBg(gameType, data);
            this.showData(data);

            this.delayCtrl = pg.time.delayCtrl();
            if (touchAuto) {
                this.delayCtrl.setTime(3);
            } else {
                this.delayCtrl.setTime(10000000);
            }
            await this.delayCtrl.wait();

            this.close();
            resolve('');
        });
    }
    close() {
        this.node.active = false;
    }
    initEvent() {
        pg.view.touchOn(this.btn_close, this.onTouchClose, this);
    }
    onTouchClose() {
        if (this.delayCtrl) {
            this.delayCtrl.reset();
        } else {
            this.close();
        }
    }
    showData(data) {
        let list = data.result.sentences[0].details;
        // 列表处理
        let str = "";
        for (let i = 0; i < list.length; i++) {
            let li = list[i];
            let s = "";
            if (li.overall > 40) {
                s = `<color=#000000>${li.word}</c>`
            } else {
                s = `<color=#FF0000> ${li.word} </c>`
            }
            str += s;
        }
        this.label_rich.getComponent(cc.RichText).string = str;
    }
    showBg(gameType, data) {
        let type = null;
        let score = data.result.overall;
        if (gameType == 3) {
            type = score > 60 ? LayoutTip.LAYOUT_TIP_TYPE.LAYOUT_TIP_TYPE_RIGHT : LayoutTip.LAYOUT_TIP_TYPE.LAYOUT_TIP_TYPE_WRONG;
        } else {
            type = score > 60 ? LayoutTip.LAYOUT_TIP_TYPE.LAYOUT_TIP_TYPE_EXCELLENT : score > 10 ? LayoutTip.LAYOUT_TIP_TYPE.LAYOUT_TIP_TYPE_GOOD : LayoutTip.LAYOUT_TIP_TYPE.LAYOUT_TIP_TYPE_TRYAGAIN;
        }
        this.img_right.active = type == LayoutTip.LAYOUT_TIP_TYPE.LAYOUT_TIP_TYPE_RIGHT;
        this.img_right.active && pg.hw.playLocalAudio('right')
    }



    log(str) {
        const node = cc.find('middleLayer');
        if (node) {
            node.getComponent('middleLayer').log(str);
        } else {
            console.log(str);
        }
    }
}


