// Learn cc.Class:
//  - https://docs.cocos.com/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const root = require("./root");

cc.Class({
    extends: cc.Component,

    properties: {
        back_ground_light: cc.Node,
        back_ground_1: cc.Node,
        robot_body: cc.Node,
        audio_button_list: cc.Node,
        title_text: cc.Node,
        title_text_shadow: cc.Node,
        left_text: cc.Label,
        right_text: cc.Label,
        bottom_display: cc.Node,
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad() {
 
    },


    init_load() {
        try {
            air.hideAirClassLoading();
        } catch (error) {

        }

        this.light_action();
        this.lamp_action();
        this.audio_button_update();

        //文字数据加载部分
        this.load_title(local.getTempData('text0'));
        this.load_text(local.getTempData('text1'), local.getTempData('text2'));
        this.initSize();
    },


    initSize() {

        // 注意cc.winSize只有在适配后(修改fitHeight/fitWidth后)才能获取到正确的值,因此使用cc.getFrameSize()来获取初始的屏幕大小
        let screen_size = cc.view.getFrameSize().width / cc.view.getFrameSize().height
        let design_size = cc.Canvas.instance.designResolution.width / cc.Canvas.instance.designResolution.height
        let f = screen_size >= design_size
        cc.Canvas.instance.fitHeight = f
        cc.Canvas.instance.fitWidth = !f

        const frameSize = cc.view.getFrameSize();
        this._frameSize = frameSize;

        this._designSize = cc.view.getDesignResolutionSize();

        let sx = cc.winSize.width / frameSize.width;
        let sy = cc.winSize.height / frameSize.height;
        this._cocosScale = Math.min(sx, sy);

        sx = frameSize.width / this._designSize.width;
        sy = frameSize.height / this._designSize.height;
        this._mapScaleMin = Math.min(sx, sy) * this._cocosScale;
        this._mapScaleMax = Math.max(sx, sy) * this._cocosScale;
    },
    start() {
        au.play('audio4');
    },

    load_title(str) {
        this.title_text.getComponent(cc.Label).string = str;
        this.title_text_shadow.getComponent(cc.Label).string = str;
    },

    load_text(str1, str2) {
        if (root.rand(50)) {
            this.left_text.node.parent._tips = true;
            this.right_text.node.parent._tips = false;
            var s1 = str1;
            var s2 = str2;
        } else {
            this.left_text.node.parent._tips = false;
            this.right_text.node.parent._tips = true;
            var s1 = str2;
            var s2 = str1;
        }
        this.left_text.string = s1;
        this.right_text.string = s2;
    },

    audio_on() {
        local.setData('audio', 0);
        this.audio_button_update();
    },
    audio_off() {
        local.setData('audio', 1);
        this.audio_button_update();
    },

    audio_button_update() {
        if (local.getData('audio', true) == 1) {
            cc.find('ON', this.audio_button_list).active = true;
            cc.find('OFF', this.audio_button_list).active = false;
        } else {
            cc.find('OFF', this.audio_button_list).active = true;
            cc.find('ON', this.audio_button_list).active = false;
        }
    },

    light_action() {
        cc.tween(this.back_ground_light)
            .to(0.3, { opacity: 0 }, { easing: 'cubicIn' })
            .to(0.3, { opacity: 255 }, { easing: 'cubicIn' })
            .union()
            .repeatForever()
            .start();
        cc.tween(this.back_ground_1)
            .to(0.5, { opacity: 155 }, { easing: 'cubicIn' })
            .to(0.5, { opacity: 255 }, { easing: 'cubicIn' })
            .union()
            .repeatForever()
            .start();
    },

    lamp_action() {

        //熄灭所有
        this.robot_body.children.forEach(function (key) {
            key.opacity = 0;
        }.bind(this));
        //每秒一个周期
        var action = function () {
            var index = 0;
            this.robot_body.children.forEach(function (key) {

                this.scheduleOnce(function () {
                    cc.tween(key)
                        .to(0.3, { opacity: 255 }, { easing: 'cubicIn' })
                        .to(0.3, { opacity: 0 }, { easing: 'cubicIn' })
                        .to(0.5, { opacity: 0 })
                        .union()
                        .repeatForever()
                        .start();
                }.bind(this), 0.2 * index);
                index++;
            }.bind(this));
        }.bind(this);
        this.schedule(function () {
            action();
        }.bind(this), 5);
        action();

    },

    left(res) {
        this.action(res.target);
    },

    right(res) {
        this.action(res.target);
    },

    action(node) {


        cc.tween(this.bottom_display)
            .to(0.05, { x: -10 })
            .to(0.05, { x: 10 })
            .to(0.05, { x: -10 })
            .to(0.05, { x: 10 })
            .to(0.05, { x: 0 })
            .start();

        au.play('audio3');
        node.scale = 1;
        cc.tween(node)
            .to(0.5, { scaleY: 0.4 }, { easing: 'quintOut' })
            .call(function () {
                if (node._tips) {
                    au.play('audio1');
                } else {
                    au.play('audio2');
                }

                cc.tween(node)
                    .to(0.3, { scaleY: 1 }, { easing: 'quintIn' })
                    .start();

            }.bind(this))
            .start();
    },

    // update (dt) {},
});
