
module.exports = {

    gold_update() {
        for (var key in this.gold_component) {
            if (this.gold_component[key]) {
                this.gold_component[key].getComponent(cc.Label).string = local.getData('gold');
            }

        }
    },
    resize(node, width, height) {
        if (node.width / node.height <= width / height) {
            node.height = node.height * width / node.width;
            node.width = width;
        } else {
            node.width = node.width * height / node.height;
            node.height = height;
        }
    },
    load_image(container, url, call) {
        url = 'https://sunleigame.oss-cn-hangzhou.aliyuncs.com/%E5%90%8D%E7%94%BB%E6%89%BE%E8%8C%AC%E8%B5%84%E6%BA%90/' + url + '.jpg';
        cc.assetManager.loadRemote(url, function (err, texture) {
            var sprite = new cc.SpriteFrame(texture);
            container.spriteFrame = sprite;
            call(container.node);
        });
    },
    chinese_number(a) {
        var arr = ['零', '一', '二', '三', '四', '五', '六', '七', '八', '九', '十', '十一', '十二', '十三', '十四', '十五', '十六', '十七', '十八', '十九', '二十'];
        return (arr[a]);
    },
    insert(prefab) {
        var node = cc.instantiate(prefab);
        node.parent = cc.find('Canvas');
        var index = 0;
        cc.find('content', node).children.forEach(function (key) {
            key.scaleX = 0;
            local.scheduleOnce(function () {
                cc.tween(key)
                    .to(0.1, { scaleX: 1 })
                    .start();
            }, index * 0.05);
            index++;
        });
        return (node);
    },
    close(node) {
        cc.tween(cc.find('content', node))
            .to(0.1, { scaleX: 0 }, { easing: 'bounceInOut' })
            .call(function () {
                node.destroy();
            })
            .start();
    },
    click_audio() {

    },
    getRandIntArray(length = 1, a = 1, b = length) {
        var array = Array();
        for (var s = a; s <= b; s++) {
            array.push(s);
        }
        array.sort(function () {
            return 0.5 - Math.random();
        });
        for (var r = 1; r <= (b - length); r++) {
            array.pop();
        }
        return (array);
    },
    getDate(time) {
        var sun = this;
        if (typeof (time) == "undefined") {
            time = sun.getTime() * 1000;
        } else {
            time *= 1000;
        }
        var oDate = new Date(time);
        var oYear = oDate.getFullYear();
        var oMonth = oDate.getMonth() + 1;
        var oDay = oDate.getDate();
        var oTime = oYear + '-' + sun.getzf(oMonth) + '-' + sun.getzf(oDay); 
        return oTime;
    },
    getzf(num) {
        if (parseInt(num) < 10) {
            num = '0' + num;
        }
        return num;
    },
    rand: function (num) {
        var array = Array();
        for (var s = 1; s <= 100; s++) {
            array.push(s);
        }
        var ins = array[Math.ceil(Math.random() * 100 - 1)];
        if (ins <= num) {
            return (true);
        } else {
            return (false);
        }
    },
    randInt: function (min, max) {
        return (min + Math.round(Math.random() * (max - min)));
    },
    getTime: function () {
        return (Date.parse(new Date()) / 1000);
    },
    getMoveCoordinates(initialNode, targetNode) {
        var initialNodeMat4 = cc.mat4();
        var targetNodeMat4 = cc.mat4();
        initialNode.getWorldMatrix(initialNodeMat4)
        targetNode.getWorldMatrix(targetNodeMat4)
        var position = new cc.v2(targetNodeMat4.m12 - initialNodeMat4.m12, targetNodeMat4.m13 - initialNodeMat4.m13);
        return (position);
    },

}