import {Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef} from '@angular/core';
import * as _ from 'lodash'; 

@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.scss']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {

  // titleObj = {
  //   audio_url: 'http://iplayabc-courseware.oss-cn-beijing.aliyuncs.com/dev/imman/audios/d108d5d06105fda0526059a3e372f926.mp3',
  //   content: 'what is this?&nbsp;',
  //   icons: [],
  //   type: 'a'
  // }; 

  titleObj = {
    audio_url: '',
    content: '',
    icons: [],
    type: ''
  };

  teststr = "";

  constructor(private appRef: ApplicationRef) {  

  }

  ngOnInit() {
    let _this = this; 
    (<any>window).courseware.getData(function(data){ 
      if(data){
        _this.titleObj = data;
        setTimeout(() => {
          _this.appRef.tick();
        }, 1); 
      } 
    });
    
  } 

  ngOnChanges() {
  }

  ngOnDestroy() {

  }

  updateTitleObjSuccess(titleObj) {
    this.titleObj = titleObj;
    this.save();
  }

  onTitleAudioUploadSuccess(res) {
    this.titleObj.audio_url = res.url;
    this.save();
  }

  save() { 
    (<any>window).courseware.setData(this.titleObj);
  }

}
