import { Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef } from '@angular/core';
import { NzInputModule } from 'ng-zorro-antd/input';



@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {

  msg = "gt";

  // 储存数据用
  KEY = "test_01_gt1";
  // 储存对象
  item;


  constructor(private appRef: ApplicationRef, private changeDetectorRef: ChangeDetectorRef) {
  }

  ngOnInit() {

    // 获取存储的数据
    const getData = (<any>window).courseware.getData;
    getData(data => {
      if (data) {
        this.msg = data.msg;
      } else {
        this.msg = "";
      }
    }, this.KEY)
  }

  ngOnChanges() {
  }

  ngOnDestroy() {
  }

  saveItem() {
    console.log("save: " + this.msg);
    this.save();
  }

  /**
   * 储存数据
   */
  save() {
    (<any>window).courseware.setData({ msg: this.msg }, null, this.KEY);
    this.refresh();
  }

  /**
   * 刷新 渲染页面
   * 立即执行
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }
}

