import { Component, ElementRef, ViewChild, OnInit, Input, OnDestroy, HostListener } from '@angular/core';

import {
  Label,
  MySprite, tweenChange,

} from './Unit';
import { res, resAudio } from './resources';

import { Subject } from 'rxjs';
import { debounceTime } from 'rxjs/operators';

import TWEEN from '@tweenjs/tween.js';




@Component({
  selector: 'app-play',
  templateUrl: './play.component.html',
  styleUrls: ['./play.component.css']
})
export class PlayComponent implements OnInit, OnDestroy {

  @ViewChild('canvas', { static: true }) canvas: ElementRef;
  @ViewChild('wrap', { static: true }) wrap: ElementRef;

  // 数据
  data;

  ctx;
  canvasWidth = 1280; // canvas实际宽度
  canvasHeight = 720; // canvas实际高度
  canvasBaseW = 1280; // canvas 资源预设宽度
  canvasBaseH = 720;  // canvas 资源预设高度

  KEY = "test_01_gt1";

  @HostListener('window:resize', ['$event'])
  onResize(event) {
    // this.winResizeEventStream.next();
  }

  ngOnInit() {

    // 获取数据
    const getData = (<any>window).courseware.getData;
    getData((data) => {

      if (data && typeof data == 'object') {
        this.data = data;
      } else {
        this.data = { msg: "xxx" }
      }
      console.log('data:', data);
      // 初始化
      this.init();

    }, this.KEY);

  }

  ngOnDestroy() {

  }


  init() {
    this.canvasWidth = this.wrap.nativeElement.clientWidth;
    this.canvasHeight = this.wrap.nativeElement.clientHeight;
    this.canvas.nativeElement.width = this.wrap.nativeElement.clientWidth;
    this.canvas.nativeElement.height = this.wrap.nativeElement.clientHeight;

    this.ctx = this.canvas.nativeElement.getContext('2d');
    this.canvas.nativeElement.width = this.canvasWidth;
    this.canvas.nativeElement.height = this.canvasHeight;

    window['curCtx'] = this.ctx;

    // 设置字体
    this.ctx.font = "18px bold 黑体";
    // 设置颜色
    this.ctx.fillStyle = "#ff0";
    // 设置水平对齐方式
    this.ctx.textAlign = "center";
    // 设置垂直对齐方式
    this.ctx.textBaseline = "middle";
    // 绘制文字（参数：要写的字，x坐标，y坐标）
    this.ctx.fillText(this.data.msg, 100, 100);

    window["air"].hideAirClassLoading("dvps-test", this.data); // 固定写法, 画布渲染完毕关闭兔子
  }
}
