const {ccclass, property} = cc._decorator;

interface GameCardData {
    id: number;
    uuid: string;
    template_name: string;
    template_description: string;
    cover: string;
    cw_cover: string;
    data: string;
    seq: number;
}

@ccclass
export default class GameCard extends cc.Component {
    @property(cc.Sprite)
    thumbnailSprite: cc.Sprite = null;

    @property(cc.Label)
    titleLabel: cc.Label = null;

    @property(cc.Node)
    cardBg: cc.Node = null;

    private gameData: GameCardData = null;

    onLoad() {
        // 添加点击事件
        this.node.on('click', this.onCardClick, this);
    }

    public init(data: GameCardData) {
        this.gameData = data;
        this.updateDisplay();
    }

    private updateDisplay() {
        if (!this.gameData) return;

        // 设置标题
        if (this.titleLabel) {
            this.titleLabel.string = this.gameData.template_description || '未知游戏';
        }

        // 加载并设置缩略图
        if (this.thumbnailSprite && (this.gameData.cover || this.gameData.cw_cover)) {
            const cv = this.gameData.cw_cover ? this.gameData.cw_cover : this.gameData.cover;
            cc.loader.load(cv, (err, texture) => {
                if (!err && texture) {
                    const spriteFrame = new cc.SpriteFrame(texture);
                    this.thumbnailSprite.spriteFrame = spriteFrame;
                }
            });
        }
    }

    private onCardClick() {
        if (this.gameData) {
            console.log('点击游戏卡片:', this.gameData.template_description);
            // 派发事件通知父节点
            this.node.emit('onGameCardClick', this.gameData);
        }
    }

    onDestroy() {
        this.node.off('click', this.onCardClick, this);
    }
} 